/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopbase.utils;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.Calendar;

public class SPHelper {
    private static SharedPreferences sp;
    private static SharedPreferences.Editor editor;

    public static void initSPHelper(Context context, String name) {
        if (sp == null) {
            sp = context.getSharedPreferences(name, 0);
            editor = sp.edit();
        }
    }

    public static void saveLanguageSetting(String language) {
        editor.putString("language", language);
        editor.commit();
    }

    public static String getLanguageSetting() {
        return sp.getString("language", "def");
    }

    public static boolean isFirstLaunched() {
        boolean result = sp.getBoolean("firstLaunched", true);
        if (result) {
            SPHelper.setFirstLaunched(false);
        }
        return result;
    }

    public static void setFirstLaunched(boolean firstLaunched) {
        editor.putBoolean("firstLaunched", firstLaunched);
        editor.commit();
    }

    public static void saveLoginStatus(boolean isLogin) {
        editor.putBoolean("isLogin", isLogin);
        editor.commit();
    }

    public static boolean isLogin() {
        return sp.getBoolean("isLogin", false);
    }

    public static boolean isFirstLaunchedDaily() {
        Calendar calendar = Calendar.getInstance();
        int currentDay = calendar.get(6);
        int currentYear = calendar.get(1);
        Long lastLaunchedTime = sp.getLong("lastLaunchedTime", 0L);
        calendar.setTimeInMillis(lastLaunchedTime);
        int lastDay = calendar.get(6);
        int lastYear = calendar.get(1);
        SPHelper.saveLastLaunchedTime();
        return currentDay != lastDay || currentYear != lastYear;
    }

    public static void saveLastLaunchedTime() {
        editor.putLong("lastLaunchedTime", System.currentTimeMillis());
        editor.commit();
    }
}

