/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopbase.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.beatop.btopbase.network.NetWorkServer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class NetWorkUtils {
    private static Retrofit retrofit;
    private static NetWorkUtils netWork;
    private static NetWorkServer netWorkServer;
    private static final String BASE_URL = "http:api.cheesedu.com/v2/";

    private NetWorkUtils() {
        if (retrofit == null) {
            retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new GsonBuilder().create())).build();
            netWork = this;
            netWorkServer = (NetWorkServer)retrofit.create(NetWorkServer.class);
        }
    }

    public static synchronized NetWorkUtils getInstance() {
        if (retrofit == null) {
            new NetWorkUtils();
        }
        return netWork;
    }

    public synchronized NetWorkServer getNetWorkServer() {
        return netWorkServer;
    }

    public static boolean isNetConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null && ni.isConnectedOrConnecting();
    }

    public int getNetworkType(Context context) {
        int netType = 0;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return netType;
        }
        return networkInfo.getType();
    }
}

