package com.beatop.btopbase.utils;

import android.content.Context;
import android.content.SharedPreferences;

import java.util.Calendar;
import java.util.Date;

/**
 * Created by Administrator on 2016/9/26.
 */
public class SPHelper {
    private static SharedPreferences sp;
    private static SharedPreferences.Editor editor;

    public static void initSPHelper(Context context, String name) {
        if (sp == null) {
            sp = context.getSharedPreferences(name, Context.MODE_PRIVATE);
            editor = sp.edit();
        }
    }

    public static void saveLanguageSetting(String language) {
        editor.putString("language", language);
        editor.commit();
    }

    public static String getLanguageSetting() {
        return sp.getString("language", "def");
    }

    public static boolean isFirstLaunched() {
        boolean result = sp.getBoolean("firstLaunched", true);
        if (result) {
            setFirstLaunched(false);
        }
        return result;
    }

    public static void setFirstLaunched(boolean firstLaunched) {
        editor.putBoolean("firstLaunched", firstLaunched);
        editor.commit();
    }

    public static void saveLoginStatus(boolean isLogin) {
        editor.putBoolean("isLogin", isLogin);
        editor.commit();

    }

    public static boolean isLogin() {
        return sp.getBoolean("isLogin", false);
    }

    /**
     * @return
     */
    public static boolean isFirstLaunchedDaily() {
        Calendar calendar = Calendar.getInstance();
        int currentDay = calendar.get(Calendar.DAY_OF_YEAR);
        int currentYear = calendar.get(Calendar.YEAR);
        Long lastLaunchedTime = sp.getLong("lastLaunchedTime", 0);
        calendar.setTimeInMillis(lastLaunchedTime);
        int lastDay = calendar.get(Calendar.DAY_OF_YEAR);
        int lastYear = calendar.get(Calendar.YEAR);
        saveLastLaunchedTime();
        return currentDay != lastDay || currentYear != lastYear;
    }

    public static void saveLastLaunchedTime() {
        editor.putLong("lastLaunchedTime", System.currentTimeMillis());
        editor.commit();

    }


}
