package com.beatop.btopbase;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Bundle;

import com.beatop.btopbase.utils.SPHelper;

/**
 * Created by Administrator on 2016/9/26.
 */
public abstract class BTBaseActivity extends Activity {
    protected final String TAG = "BTop::" + getClass().getSimpleName();
    protected final String LANGUAGE_CHANGE_BROADCAST = "change_language_broadcast";
    protected boolean isZh = true;
    protected Resources resources;
    protected LanguageChangeReceiver receiver;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        resources = getResources();
        receiver = new LanguageChangeReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(LANGUAGE_CHANGE_BROADCAST);
        registerReceiver(receiver, filter);
        if (SPHelper.getLanguageSetting().equals("zh")) {
            isZh = true;
        } else {
            isZh = false;
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        unregisterReceiver(receiver);
    }

    protected abstract void onLanguageChanged();

    protected class LanguageChangeReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(LANGUAGE_CHANGE_BROADCAST)) {
                if (SPHelper.getLanguageSetting().equals("zh")) {
                    isZh = true;
                } else {
                    isZh = false;
                }
                onLanguageChanged();
            }
        }
    }

}
