package com.beatop.webcontain;

import android.app.ProgressDialog;
import android.os.Bundle;
import android.util.Base64;
import android.webkit.WebSettings;
import android.webkit.WebView;

import org.apache.cordova.CordovaActivity;
import org.apache.cordova.CordovaInterfaceImpl;

import java.io.IOException;
import java.io.InputStream;

/**
 * Created by Administrator on 2016/9/19.
 */
public class WebContainerActivity extends CordovaActivity {
    private ProgressDialog pd;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        pd = new ProgressDialog(this);
        pd.setMessage("loading...");
    }

    @Override
    protected CordovaInterfaceImpl makeCordovaInterface() {
        return new CordovaInterfaceImpl(this) {
            @Override
            public Object onMessage(String id, Object data) {
                // Plumb this to CordovaActivity.onMessage for backwards compatibility
                return WebContainerActivity.this.onMessage(id, data);
            }

            @Override
            public void onPageStarted(WebView view, String url) {
                pd.show();
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                pd.dismiss();
                injectCordovaJS(view);
            }
        };
    }


    public static void injectScriptFile(WebView view, String scriptFile) {
        InputStream input;
        try {
            input = view.getContext().getAssets().open(scriptFile);
            byte[] buffer = new byte[input.available()];
            input.read(buffer);
            input.close();

            // String-ify the script byte-array using BASE64 encoding !!!
            String encoded = Base64.encodeToString(buffer, Base64.NO_WRAP);
//            String s = String.format("javascript:(function() {" +
//                    "var script = document.createElement('script');" +
//                    "script.type = 'text/javascript';" +
//                    "script.src = \"%s\";" +
//                    "document.getElementsByTagName('head')[0].appendChild(script);" +
//                    "})()"
//                    ,"file:///android_asset/cordova-android/cordova.android.js");
//            view.loadUrl(s);

            view.loadUrl("javascript:(function() {if(window.cordova){return;};"
                    + "var parent = document.getElementsByTagName('head').item(0);"
                    + "var script = document.createElement('script');" + "script.type = 'text/javascript';"
                    +
                    // Tell the browser to BASE64-decode the string into your script !!!
                    "script.innerHTML = window.atob('" + encoded + "');" + "parent.appendChild(script)"
                    + "})()");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void injectCordovaJS(WebView view) {
        WebSettings webSettings = view.getSettings();
        webSettings.setJavaScriptEnabled(true);
        injectScriptFile(view, "www/cordova.js");
//        injectScriptFile(view, "www/cordova_plugins.js");
//        injectScriptFile(view, "www/cordova-js-src/exec.js");
//        injectScriptFile(view, "www/cordova-js-src/platform.js");
//        injectScriptFile(view, "www/cordova_plugins.js");
//        injectScriptFile(view, "www/cordova-js-src/android/nativeapiprovider.js");
//        injectScriptFile(view, "www/cordova-js-src/android/promptbasednativeapi.js");
//        injectScriptFile(view, "www/cordova-js-src/plugin.android/app.js");
    }
}
