/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.beardedhen.androidbootstrap.BootstrapBaseThumbnail;
import com.beardedhen.androidbootstrap.BootstrapDrawableFactory;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapSize;
import com.beardedhen.androidbootstrap.api.view.RoundableView;
import com.beardedhen.androidbootstrap.utils.ColorUtils;
import com.beardedhen.androidbootstrap.utils.ViewUtils;

public class BootstrapThumbnail
extends BootstrapBaseThumbnail
implements RoundableView {
    private static final String TAG = "com.beardedhen.androidbootstrap.BootstrapThumbnail";
    private Paint placeholderPaint;
    private final RectF imageRect = new RectF();
    private boolean roundedCorners;
    private float baselineCornerRadius;

    public BootstrapThumbnail(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapThumbnail(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapThumbnail(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise(attrs);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(TAG, super.onSaveInstanceState());
        bundle.putBoolean("com.beardedhen.androidbootstrap.api.view.Roundable", this.roundedCorners);
        return bundle;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.roundedCorners = bundle.getBoolean("com.beardedhen.androidbootstrap.api.view.Roundable");
            state = bundle.getParcelable(TAG);
        }
        super.onRestoreInstanceState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialise(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapThumbnail);
        try {
            int typeOrdinal = a.getInt(R.styleable.BootstrapThumbnail_bootstrapBrand, -1);
            int sizeOrdinal = a.getInt(R.styleable.BootstrapThumbnail_bootstrapSize, -1);
            this.hasBorder = a.getBoolean(R.styleable.BootstrapCircleThumbnail_hasBorder, true);
            this.bootstrapSize = DefaultBootstrapSize.fromAttributeValue(sizeOrdinal).scaleFactor();
            this.bootstrapBrand = typeOrdinal == -1 ? DefaultBootstrapBrand.PRIMARY : DefaultBootstrapBrand.fromAttributeValue(typeOrdinal);
        }
        finally {
            a.recycle();
        }
        this.placeholderPaint = new Paint();
        this.placeholderPaint.setColor(ColorUtils.resolveColor(R.color.bootstrap_gray_light, this.getContext()));
        this.placeholderPaint.setStyle(Paint.Style.FILL);
        this.placeholderPaint.setAntiAlias(true);
        this.baselineCornerRadius = this.getResources().getDimension(R.dimen.bthumbnail_rounded_corner);
        this.baselineBorderWidth = this.getResources().getDimension(R.dimen.bthumbnail_default_border);
        this.setScaleType(ImageView.ScaleType.CENTER_CROP);
        super.initialise(attrs);
    }

    @Override
    protected void updateImageState() {
        this.updateBackground();
        this.updatePadding();
        this.invalidate();
    }

    private void updateBackground() {
        Drawable bg = null;
        if (this.hasBorder) {
            bg = BootstrapDrawableFactory.bootstrapThumbnail(this.getContext(), this.bootstrapBrand, (int)(this.baselineOuterBorderWidth * this.bootstrapSize), ColorUtils.resolveColor(R.color.bootstrap_thumbnail_background, this.getContext()), this.roundedCorners);
        }
        ViewUtils.setBackgroundDrawable((View)this, bg);
    }

    private void updatePadding() {
        if (Build.VERSION.SDK_INT >= 16) {
            int p = this.hasBorder ? (int)(this.baselineBorderWidth * this.bootstrapSize) : 0;
            this.setPadding(p, p, p, p);
            this.setCropToPadding(this.hasBorder);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.sourceBitmap == null) {
            float padding;
            this.imageRect.top = padding = this.hasBorder ? this.baselineBorderWidth * this.bootstrapSize : 0.0f;
            this.imageRect.bottom = (float)this.getHeight() - padding;
            this.imageRect.left = padding;
            this.imageRect.right = (float)this.getWidth() - padding;
            if (this.roundedCorners) {
                canvas.drawRoundRect(this.imageRect, this.baselineCornerRadius * this.bootstrapSize, this.baselineCornerRadius * this.bootstrapSize, this.placeholderPaint);
            } else {
                canvas.drawRect(this.imageRect, this.placeholderPaint);
            }
        } else {
            super.onDraw(canvas);
        }
    }

    @Override
    public void setRounded(boolean rounded) {
        this.roundedCorners = rounded;
        this.updateImageState();
    }

    @Override
    public boolean isRounded() {
        return this.roundedCorners;
    }
}

