/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.text.TextPaint;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.api.attributes.ViewGroupPosition;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.ExpandDirection;
import com.beardedhen.androidbootstrap.utils.ColorUtils;
import com.beardedhen.androidbootstrap.utils.DimenUtils;

class BootstrapDrawableFactory {
    BootstrapDrawableFactory() {
    }

    static Drawable bootstrapButton(Context context, BootstrapBrand brand, int strokeWidth, int cornerRadius, ViewGroupPosition position, boolean showOutline, boolean rounded) {
        DefaultBootstrapBrand db;
        GradientDrawable defaultGd = new GradientDrawable();
        GradientDrawable activeGd = new GradientDrawable();
        GradientDrawable disabledGd = new GradientDrawable();
        defaultGd.setColor(showOutline ? 0 : brand.defaultFill(context));
        activeGd.setColor(showOutline ? brand.activeFill(context) : brand.activeFill(context));
        disabledGd.setColor(showOutline ? 0 : brand.disabledFill(context));
        defaultGd.setStroke(strokeWidth, brand.defaultEdge(context));
        activeGd.setStroke(strokeWidth, brand.activeEdge(context));
        disabledGd.setStroke(strokeWidth, brand.disabledEdge(context));
        if (showOutline && brand instanceof DefaultBootstrapBrand && (db = (DefaultBootstrapBrand)brand) == DefaultBootstrapBrand.SECONDARY) {
            int color2 = ColorUtils.resolveColor(R.color.bootstrap_brand_secondary_border, context);
            defaultGd.setStroke(strokeWidth, color2);
            activeGd.setStroke(strokeWidth, color2);
            disabledGd.setStroke(strokeWidth, color2);
        }
        BootstrapDrawableFactory.setupDrawableCorners(position, rounded, cornerRadius, defaultGd, activeGd, disabledGd);
        return BootstrapDrawableFactory.setupStateDrawable(position, strokeWidth, defaultGd, activeGd, disabledGd);
    }

    static Drawable bootstrapLabel(Context context, BootstrapBrand bootstrapBrand, boolean rounded, float height) {
        int cornerRadius = (int)DimenUtils.pixelsFromDpResource(context, R.dimen.bootstrap_default_corner_radius);
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(bootstrapBrand.defaultFill(context));
        drawable.setCornerRadius(rounded ? height / 2.0f : (float)cornerRadius);
        return drawable;
    }

    static Drawable bootstrapEditText(Context context, BootstrapBrand bootstrapBrand, float strokeWidth, float cornerRadius, boolean rounded) {
        StateListDrawable drawable = new StateListDrawable();
        GradientDrawable activeDrawable = new GradientDrawable();
        GradientDrawable disabledDrawable = new GradientDrawable();
        GradientDrawable defaultDrawable = new GradientDrawable();
        activeDrawable.setColor(ColorUtils.resolveColor(17170443, context));
        disabledDrawable.setColor(ColorUtils.resolveColor(17170443, context));
        defaultDrawable.setColor(ColorUtils.resolveColor(17170443, context));
        if (rounded) {
            activeDrawable.setCornerRadius(cornerRadius);
            disabledDrawable.setCornerRadius(cornerRadius);
            defaultDrawable.setCornerRadius(cornerRadius);
        }
        int defaultBorder = ColorUtils.resolveColor(R.color.bootstrap_brand_secondary_border, context);
        int disabledBorder = ColorUtils.resolveColor(R.color.bootstrap_edittext_disabled, context);
        activeDrawable.setStroke((int)strokeWidth, bootstrapBrand.defaultEdge(context));
        disabledDrawable.setStroke((int)strokeWidth, disabledBorder);
        defaultDrawable.setStroke((int)strokeWidth, defaultBorder);
        drawable.addState(new int[]{16842908}, (Drawable)activeDrawable);
        drawable.addState(new int[]{-16842910}, (Drawable)disabledDrawable);
        drawable.addState(new int[0], (Drawable)defaultDrawable);
        return drawable;
    }

    static Drawable bootstrapCircleThumbnail(Context context, BootstrapBrand bootstrapBrand, @ColorInt int outerBorderWidth, @ColorInt int bg) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(1);
        drawable.setColor(bg);
        drawable.setStroke(outerBorderWidth, bootstrapBrand.defaultEdge(context));
        return drawable;
    }

    static Drawable bootstrapThumbnail(Context context, BootstrapBrand bootstrapBrand, @ColorInt int outerBorderWidth, @ColorInt int bg, boolean rounded) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(0);
        drawable.setColor(bg);
        drawable.setStroke(outerBorderWidth, bootstrapBrand.defaultEdge(context));
        float r = DimenUtils.pixelsFromDpResource(context, R.dimen.bthumbnail_rounded_corner);
        if (rounded) {
            drawable.setCornerRadii(new float[]{r, r, r, r, r, r, r, r});
        }
        return drawable;
    }

    static Drawable bootstrapAlert(Context context, BootstrapBrand bootstrapBrand) {
        GradientDrawable disabledGd = new GradientDrawable();
        int strokeWidth = context.getResources().getDimensionPixelSize(R.dimen.bootstrap_alert_stroke_width);
        disabledGd.setColor(ColorUtils.increaseOpacityFromInt(context, bootstrapBrand.getColor(), 40));
        disabledGd.setCornerRadius(6.0f);
        disabledGd.setStroke(strokeWidth, ColorUtils.increaseOpacityFromInt(context, bootstrapBrand.getColor(), 70));
        return disabledGd;
    }

    static ColorStateList bootstrapButtonText(Context context, boolean outline, BootstrapBrand brand) {
        DefaultBootstrapBrand db;
        int disabledColor;
        int defaultColor = outline ? brand.defaultFill(context) : brand.defaultTextColor(context);
        int activeColor = outline ? ColorUtils.resolveColor(17170443, context) : brand.activeTextColor(context);
        int n = disabledColor = outline ? brand.disabledFill(context) : brand.disabledTextColor(context);
        if (outline && brand instanceof DefaultBootstrapBrand && (db = (DefaultBootstrapBrand)brand) == DefaultBootstrapBrand.SECONDARY) {
            disabledColor = defaultColor = ColorUtils.resolveColor(R.color.bootstrap_brand_secondary_border, context);
        }
        return new ColorStateList(BootstrapDrawableFactory.getStateList(), BootstrapDrawableFactory.getColorList(defaultColor, activeColor, disabledColor));
    }

    static Drawable bootstrapWell(@ColorInt int backgroundColor, int cornerRadius, int strokeWidth, @ColorInt int strokeColor) {
        GradientDrawable background = new GradientDrawable();
        background.setColor(backgroundColor);
        background.setCornerRadius((float)cornerRadius);
        background.setStroke(strokeWidth, strokeColor);
        return background;
    }

    private static StateListDrawable setupStateDrawable(ViewGroupPosition position, int strokeWidth, GradientDrawable defaultGd, GradientDrawable activeGd, GradientDrawable disabledGd) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        LayerDrawable defaultLayer = new LayerDrawable(new Drawable[]{defaultGd});
        LayerDrawable activeLayer = new LayerDrawable(new Drawable[]{activeGd});
        LayerDrawable disabledLayer = new LayerDrawable(new Drawable[]{disabledGd});
        LayerDrawable[] ldAry = new LayerDrawable[]{defaultLayer, activeLayer, disabledLayer};
        int n = strokeWidth * -1;
        if (position != null) {
            switch (position) {
                case MIDDLE_HORI: {
                    BootstrapDrawableFactory.setInsetOnLayers(ldAry, n, 0, 0, 0);
                    break;
                }
                case END: {
                    BootstrapDrawableFactory.setInsetOnLayers(ldAry, n, 0, 0, 0);
                    break;
                }
                case MIDDLE_VERT: {
                    BootstrapDrawableFactory.setInsetOnLayers(ldAry, 0, n, 0, 0);
                    break;
                }
                case BOTTOM: {
                    BootstrapDrawableFactory.setInsetOnLayers(ldAry, 0, n, 0, 0);
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 14) {
            stateListDrawable.addState(new int[]{16843623}, (Drawable)activeLayer);
        }
        stateListDrawable.addState(new int[]{16843518}, (Drawable)activeLayer);
        stateListDrawable.addState(new int[]{16842908}, (Drawable)activeLayer);
        stateListDrawable.addState(new int[]{16842919}, (Drawable)activeLayer);
        stateListDrawable.addState(new int[]{0x10100A1}, (Drawable)activeLayer);
        stateListDrawable.addState(new int[]{-16842910}, (Drawable)disabledLayer);
        stateListDrawable.addState(new int[0], (Drawable)defaultLayer);
        return stateListDrawable;
    }

    private static void setupDrawableCorners(ViewGroupPosition position, boolean rounded, int r, GradientDrawable defaultGd, GradientDrawable activeGd, GradientDrawable disabledGd) {
        if (rounded) {
            if (position == ViewGroupPosition.SOLO) {
                defaultGd.setCornerRadius((float)r);
                activeGd.setCornerRadius((float)r);
                disabledGd.setCornerRadius((float)r);
            } else {
                float[] radii;
                switch (position) {
                    case MIDDLE_HORI: {
                        radii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                        break;
                    }
                    case MIDDLE_VERT: {
                        radii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                        break;
                    }
                    case TOP: {
                        radii = new float[]{r, r, r, r, 0.0f, 0.0f, 0.0f, 0.0f};
                        break;
                    }
                    case BOTTOM: {
                        radii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, r, r, r, r};
                        break;
                    }
                    case START: {
                        radii = new float[]{r, r, 0.0f, 0.0f, 0.0f, 0.0f, r, r};
                        break;
                    }
                    case END: {
                        radii = new float[]{0.0f, 0.0f, r, r, r, r, 0.0f, 0.0f};
                        break;
                    }
                    default: {
                        radii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                    }
                }
                defaultGd.setCornerRadii(radii);
                activeGd.setCornerRadii(radii);
                disabledGd.setCornerRadii(radii);
            }
        }
    }

    private static int[][] getStateList() {
        if (Build.VERSION.SDK_INT >= 14) {
            return new int[][]{{16843623}, {16843518}, {16842908}, {0x10100A1}, {16842919}, {16843623}, {-16842910}, new int[0]};
        }
        return new int[][]{{16843518}, {16842908}, {0x10100A1}, {16842919}, {16843623}, {-16842910}, new int[0]};
    }

    private static int[] getColorList(int defaultColor, int activeColor, int disabledColor) {
        if (Build.VERSION.SDK_INT >= 14) {
            return new int[]{activeColor, activeColor, activeColor, activeColor, activeColor, activeColor, disabledColor, defaultColor};
        }
        return new int[]{activeColor, activeColor, activeColor, activeColor, activeColor, disabledColor, defaultColor};
    }

    static StateListDrawable bootstrapDropDownArrow(Context context, int width, int height, ExpandDirection expandDirection, boolean outline, BootstrapBrand brand) {
        int disabledColor;
        StateListDrawable stateListDrawable = new StateListDrawable();
        int defaultColor = outline ? brand.defaultFill(context) : brand.defaultTextColor(context);
        int activeColor = outline ? ColorUtils.resolveColor(17170443, context) : brand.activeTextColor(context);
        int n = disabledColor = outline ? brand.disabledFill(context) : brand.disabledTextColor(context);
        if (Build.VERSION.SDK_INT >= 14) {
            stateListDrawable.addState(new int[]{16843623}, BootstrapDrawableFactory.createArrowIcon(context, width, height, activeColor, expandDirection));
        }
        stateListDrawable.addState(new int[]{16843518}, BootstrapDrawableFactory.createArrowIcon(context, width, height, activeColor, expandDirection));
        stateListDrawable.addState(new int[]{16842908}, BootstrapDrawableFactory.createArrowIcon(context, width, height, activeColor, expandDirection));
        stateListDrawable.addState(new int[]{16842919}, BootstrapDrawableFactory.createArrowIcon(context, width, height, activeColor, expandDirection));
        stateListDrawable.addState(new int[]{0x10100A1}, BootstrapDrawableFactory.createArrowIcon(context, width, height, activeColor, expandDirection));
        stateListDrawable.addState(new int[]{-16842910}, BootstrapDrawableFactory.createArrowIcon(context, width, height, disabledColor, expandDirection));
        stateListDrawable.addState(new int[0], BootstrapDrawableFactory.createArrowIcon(context, width, height, defaultColor, expandDirection));
        return stateListDrawable;
    }

    static StateListDrawable bootstrapAlertCloseIcon(Context context, int width, int height, int inset) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        int defaultColor = ColorUtils.resolveColor(R.color.bootstrap_alert_cross_default, context);
        int activeColor = ColorUtils.resolveColor(R.color.bootstrap_gray, context);
        int disabledColor = ColorUtils.resolveColor(R.color.bootstrap_alert_cross_default, context);
        if (Build.VERSION.SDK_INT >= 14) {
            stateListDrawable.addState(new int[]{16843623}, BootstrapDrawableFactory.createCloseCrossIcon(context, width, height, activeColor, inset));
        }
        stateListDrawable.addState(new int[]{16843518}, BootstrapDrawableFactory.createCloseCrossIcon(context, width, height, activeColor, inset));
        stateListDrawable.addState(new int[]{16842908}, BootstrapDrawableFactory.createCloseCrossIcon(context, width, height, activeColor, inset));
        stateListDrawable.addState(new int[]{16842919}, BootstrapDrawableFactory.createCloseCrossIcon(context, width, height, activeColor, inset));
        stateListDrawable.addState(new int[]{0x10100A1}, BootstrapDrawableFactory.createCloseCrossIcon(context, width, height, activeColor, inset));
        stateListDrawable.addState(new int[]{-16842910}, BootstrapDrawableFactory.createCloseCrossIcon(context, width, height, disabledColor, inset));
        stateListDrawable.addState(new int[0], BootstrapDrawableFactory.createCloseCrossIcon(context, width, height, defaultColor, inset));
        return stateListDrawable;
    }

    private static Drawable createArrowIcon(Context context, int width, int height, int color2, ExpandDirection expandDirection) {
        Bitmap canvasBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(canvasBitmap);
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        paint.setStrokeWidth(1.0f);
        paint.setColor(color2);
        paint.setAntiAlias(true);
        Path path = new Path();
        path.setFillType(Path.FillType.EVEN_ODD);
        switch (expandDirection) {
            case UP: {
                path.moveTo(0.0f, (float)(height / 3 * 2));
                path.lineTo((float)width, (float)(height / 3 * 2));
                path.lineTo((float)(width / 2), (float)(height / 3));
                path.lineTo(0.0f, (float)(height / 3 * 2));
                break;
            }
            case DOWN: {
                path.moveTo(0.0f, (float)(height / 3));
                path.lineTo((float)width, (float)(height / 3));
                path.lineTo((float)(width / 2), (float)(height / 3 * 2));
                path.lineTo(0.0f, (float)(height / 3));
            }
        }
        path.close();
        canvas.drawPath(path, paint);
        return new BitmapDrawable(context.getResources(), canvasBitmap);
    }

    private static Drawable createCloseCrossIcon(Context context, int width, int height, int color2, int inset) {
        Bitmap canvasBitmap = Bitmap.createBitmap((int)(width + inset * 2), (int)(height + inset * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(canvasBitmap);
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        paint.setStrokeWidth(3.0f);
        paint.setColor(color2);
        paint.setAntiAlias(true);
        Path path = new Path();
        path.setFillType(Path.FillType.EVEN_ODD);
        path.moveTo((float)inset, (float)inset);
        path.lineTo((float)(width + inset), (float)(height + inset));
        path.moveTo((float)(width + inset), (float)inset);
        path.lineTo((float)inset, (float)(height + inset));
        path.close();
        canvas.drawPath(path, paint);
        return new BitmapDrawable(context.getResources(), canvasBitmap);
    }

    public static Drawable createBadgeDrawable(Context context, BootstrapBrand brand, int width, int height, String badgeText, boolean insideAnObject) {
        if (badgeText == null) {
            return null;
        }
        Paint badgePaint = new Paint();
        Rect canvasBounds = new Rect();
        TextPaint badgeTextPaint = new TextPaint();
        badgePaint.setFlags(1);
        badgeTextPaint.setFlags(1);
        badgeTextPaint.setTextAlign(Paint.Align.CENTER);
        badgeTextPaint.setTextSize((float)((double)height * 0.7));
        if (insideAnObject) {
            badgePaint.setColor(brand.defaultTextColor(context));
            badgeTextPaint.setColor(brand.defaultFill(context));
        } else {
            badgePaint.setColor(brand.defaultFill(context));
            badgeTextPaint.setColor(brand.defaultTextColor(context));
        }
        int rectLength = (int)badgeTextPaint.measureText(badgeText);
        Bitmap canvasBitmap = Bitmap.createBitmap((int)(width + rectLength), (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(canvasBitmap);
        canvas.getClipBounds(canvasBounds);
        int firstCircleDx = canvasBounds.left + canvasBounds.height() / 2;
        int circleDy = canvasBounds.height() / 2;
        int circleRadius = canvasBounds.height() / 2;
        int secondCircleDx = firstCircleDx + rectLength;
        Rect rect = new Rect();
        rect.left = firstCircleDx;
        rect.top = 0;
        rect.right = rect.left + rectLength;
        rect.bottom = canvasBounds.height();
        canvas.drawCircle((float)firstCircleDx, (float)circleDy, (float)circleRadius, badgePaint);
        canvas.drawRect(rect, badgePaint);
        canvas.drawCircle((float)secondCircleDx, (float)circleDy, (float)circleRadius, badgePaint);
        canvas.drawText(badgeText, (float)(canvasBounds.width() / 2), (float)(canvasBounds.height() / 2) - (badgeTextPaint.descent() + badgeTextPaint.ascent()) / 2.0f, (Paint)badgeTextPaint);
        return new BitmapDrawable(context.getResources(), canvasBitmap);
    }

    static ColorStateList bootstrapDropDownViewText(Context context) {
        int defaultColor = ColorUtils.resolveColor(R.color.bootstrap_gray_dark, context);
        int activeColor = ColorUtils.resolveColor(17170444, context);
        int disabledColor = ColorUtils.resolveColor(R.color.bootstrap_gray_light, context);
        return new ColorStateList(BootstrapDrawableFactory.getStateList(), BootstrapDrawableFactory.getColorList(defaultColor, activeColor, disabledColor));
    }

    private static void setInsetOnLayers(LayerDrawable[] ary, int l, int t, int r, int b) {
        for (LayerDrawable ld : ary) {
            ld.setLayerInset(0, l, t, r, b);
        }
    }
}

