/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap.utils;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;

public class ColorUtils {
    public static final int DISABLED_ALPHA_FILL = 165;
    public static final int DISABLED_ALPHA_EDGE = 190;
    public static final float ACTIVE_OPACITY_FACTOR_FILL = 0.125f;
    public static final float ACTIVE_OPACITY_FACTOR_EDGE = 0.025f;

    @ColorInt
    public static int resolveColor(@ColorRes int color2, Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getResources().getColor(color2, context.getTheme());
        }
        return context.getResources().getColor(color2);
    }

    @ColorInt
    public static int decreaseRgbChannels(Context context, @ColorRes int res, float percent) {
        int c = ColorUtils.resolveColor(res, context);
        int red = Color.red((int)c);
        red = (red = (int)((float)red - (float)red * percent)) > 0 ? red : 0;
        int green = Color.green((int)c);
        green = (int)((float)green - (float)green * percent);
        green = green > 0 ? green : 0;
        int blue = Color.blue((int)c);
        blue = (int)((float)blue - (float)blue * percent);
        blue = blue > 0 ? blue : 0;
        return Color.argb((int)Color.alpha((int)c), (int)red, (int)green, (int)blue);
    }

    @ColorInt
    public static int increaseOpacity(Context context, @ColorRes int res, int alpha) {
        int c = ColorUtils.resolveColor(res, context);
        return ColorUtils.increaseOpacityFromInt(context, ColorUtils.resolveColor(res, context), alpha);
    }

    @ColorInt
    public static int increaseOpacityFromInt(Context context, @ColorInt int c, int alpha) {
        return Color.argb((int)alpha, (int)Color.red((int)c), (int)Color.green((int)c), (int)Color.blue((int)c));
    }
}

