/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.text.SpannableString;
import com.beardedhen.androidbootstrap.TypefaceProvider;
import com.beardedhen.androidbootstrap.font.AwesomeTypefaceSpan;
import com.beardedhen.androidbootstrap.font.IconSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BootstrapText
extends SpannableString
implements Serializable {
    private BootstrapText(CharSequence source) {
        super(source);
    }

    public static class Builder {
        private final StringBuilder sb;
        private final Context context;
        private final boolean editMode;
        private final Map<Integer, IconSet> fontIndicesMap = new HashMap<Integer, IconSet>();

        public Builder(Context context) {
            this.sb = new StringBuilder();
            this.context = context.getApplicationContext();
            this.editMode = false;
        }

        public Builder(Context context, boolean editMode) {
            this.sb = new StringBuilder();
            this.context = context.getApplicationContext();
            this.editMode = editMode;
        }

        public Builder addText(CharSequence text) {
            this.sb.append(text);
            return this;
        }

        public Builder addFontAwesomeIcon(CharSequence iconCode) {
            IconSet iconSet = TypefaceProvider.retrieveRegisteredIconSet("fontawesome-webfont-v450.ttf", this.editMode);
            this.sb.append(iconSet.unicodeForKey(iconCode.toString().replaceAll("\\-", "_")));
            this.fontIndicesMap.put(this.sb.length(), iconSet);
            return this;
        }

        public Builder addTypicon(CharSequence iconCode) {
            IconSet iconSet = TypefaceProvider.retrieveRegisteredIconSet("typicons-v207.ttf", this.editMode);
            this.sb.append(iconSet.unicodeForKey(iconCode.toString().replaceAll("\\-", "_")));
            this.fontIndicesMap.put(this.sb.length(), iconSet);
            return this;
        }

        public Builder addMaterialIcon(CharSequence iconCode) {
            IconSet iconSet = TypefaceProvider.retrieveRegisteredIconSet("MaterialIcons-Regular.ttf", this.editMode);
            this.sb.append(iconSet.unicodeForKey(iconCode.toString().replaceAll("\\-", "_")));
            this.fontIndicesMap.put(this.sb.length(), iconSet);
            return this;
        }

        public Builder addIcon(CharSequence iconCode, IconSet iconSet) {
            this.sb.append(iconSet.unicodeForKey(iconCode.toString().replaceAll("\\-", "_")));
            this.fontIndicesMap.put(this.sb.length(), iconSet);
            return this;
        }

        public BootstrapText build() {
            BootstrapText bootstrapText = new BootstrapText(this.sb.toString());
            for (Map.Entry<Integer, IconSet> entry : this.fontIndicesMap.entrySet()) {
                int index = entry.getKey();
                AwesomeTypefaceSpan span = new AwesomeTypefaceSpan(this.context, entry.getValue());
                bootstrapText.setSpan((Object)span, index - 1, index, 18);
            }
            return bootstrapText;
        }
    }
}

