/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

abstract class BootstrapGroup
extends LinearLayout {
    public BootstrapGroup(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialise(attrs);
    }

    protected abstract void initialise(AttributeSet var1);

    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        this.updateBootstrapGroup();
    }

    protected abstract void updateBootstrapGroup();

    protected abstract void onBootstrapViewAdded();

    protected abstract void onBootstrapViewRemoved();

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        this.onBootstrapViewAdded();
    }

    public void removeAllViews() {
        super.removeAllViews();
        this.onBootstrapViewRemoved();
    }

    public void removeView(View view) {
        super.removeView(view);
        this.onBootstrapViewRemoved();
    }

    public void removeViewInLayout(View view) {
        super.removeViewInLayout(view);
        this.onBootstrapViewRemoved();
    }

    public void removeViewsInLayout(int start, int count) {
        super.removeViewsInLayout(start, count);
        this.onBootstrapViewRemoved();
    }

    public void removeViewAt(int index) {
        View child = this.getChildAt(index);
        super.removeViewAt(index);
        this.onBootstrapViewRemoved();
    }

    public void removeViews(int start, int count) {
        super.removeViews(start, count);
        this.onBootstrapViewRemoved();
    }
}

