/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import com.beardedhen.androidbootstrap.BootstrapDrawableFactory;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapSize;
import com.beardedhen.androidbootstrap.api.view.BootstrapBrandView;
import com.beardedhen.androidbootstrap.api.view.BootstrapSizeView;
import com.beardedhen.androidbootstrap.api.view.RoundableView;
import com.beardedhen.androidbootstrap.utils.DimenUtils;
import com.beardedhen.androidbootstrap.utils.ViewUtils;
import java.io.Serializable;

public class BootstrapEditText
extends EditText
implements BootstrapBrandView,
RoundableView,
BootstrapSizeView {
    private static final String TAG = "com.beardedhen.androidbootstrap.BootstrapEditText";
    private float baselineFontSize;
    private float baselineVertPadding;
    private float baselineHoriPadding;
    private float baselineStrokeWidth;
    private float baselineCornerRadius;
    private BootstrapBrand bootstrapBrand;
    private float bootstrapSize;
    private boolean rounded;

    public BootstrapEditText(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapEditText);
        try {
            this.rounded = a.getBoolean(R.styleable.BootstrapEditText_roundedCorners, false);
            int typeOrdinal = a.getInt(R.styleable.AwesomeTextView_bootstrapBrand, -1);
            int sizeOrdinal = a.getInt(R.styleable.BootstrapEditText_bootstrapSize, -1);
            this.bootstrapBrand = DefaultBootstrapBrand.fromAttributeValue(typeOrdinal);
            this.bootstrapSize = DefaultBootstrapSize.fromAttributeValue(sizeOrdinal).scaleFactor();
        }
        finally {
            a.recycle();
        }
        this.baselineFontSize = DimenUtils.pixelsFromSpResource(this.getContext(), R.dimen.bootstrap_edit_text_default_font_size);
        this.baselineVertPadding = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_edit_text_vert_padding);
        this.baselineHoriPadding = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_edit_text_hori_padding);
        this.baselineStrokeWidth = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_edit_text_edge_width);
        this.baselineCornerRadius = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_edit_text_corner_radius);
        a = this.getContext().obtainStyledAttributes(attrs, new int[]{16842927});
        try {
            this.setGravity(a.getInt(0, 16));
        }
        finally {
            a.recycle();
        }
        this.updateBootstrapState();
        this.invalidate();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(TAG, super.onSaveInstanceState());
        bundle.putBoolean("com.beardedhen.androidbootstrap.api.view.Roundable", this.rounded);
        bundle.putFloat("com.beardedhen.androidbootstrap.api.view.BootstrapSizeView", this.bootstrapSize);
        bundle.putSerializable("BootstrapBrand", (Serializable)this.bootstrapBrand);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.rounded = bundle.getBoolean("com.beardedhen.androidbootstrap.api.view.Roundable");
            this.bootstrapSize = bundle.getFloat("com.beardedhen.androidbootstrap.api.view.BootstrapSizeView");
            Serializable brand = bundle.getSerializable("BootstrapBrand");
            if (brand instanceof BootstrapBrand) {
                this.bootstrapBrand = (BootstrapBrand)brand;
            }
            state = bundle.getParcelable(TAG);
        }
        super.onRestoreInstanceState(state);
        this.updateBootstrapState();
    }

    private void updateBootstrapState() {
        int vPadding = (int)(this.baselineVertPadding * this.bootstrapSize);
        int hPadding = (int)(this.baselineHoriPadding * this.bootstrapSize);
        this.setPadding(vPadding, hPadding, vPadding, hPadding);
        int strokeWidth = (int)(this.baselineStrokeWidth * this.bootstrapSize);
        float cornerRadius = this.baselineCornerRadius * this.bootstrapSize;
        float fontSize = this.baselineFontSize * this.bootstrapSize;
        this.setTextSize(fontSize);
        Drawable bg = BootstrapDrawableFactory.bootstrapEditText(this.getContext(), this.bootstrapBrand, strokeWidth, cornerRadius, this.rounded);
        ViewUtils.setBackgroundDrawable((View)this, bg);
    }

    @Override
    public void setBootstrapBrand(@NonNull BootstrapBrand bootstrapBrand) {
        this.bootstrapBrand = bootstrapBrand;
        this.updateBootstrapState();
    }

    @Override
    @NonNull
    public BootstrapBrand getBootstrapBrand() {
        return this.bootstrapBrand;
    }

    @Override
    public void setRounded(boolean rounded) {
        this.rounded = rounded;
        this.updateBootstrapState();
    }

    @Override
    public boolean isRounded() {
        return this.rounded;
    }

    @Override
    public float getBootstrapSize() {
        return this.bootstrapSize;
    }

    @Override
    public void setBootstrapSize(float bootstrapSize) {
        this.bootstrapSize = bootstrapSize;
        this.updateBootstrapState();
    }

    @Override
    public void setBootstrapSize(DefaultBootstrapSize bootstrapSize) {
        this.setBootstrapSize(bootstrapSize.scaleFactor());
    }
}

