/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.Html;
import android.util.AttributeSet;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.beardedhen.androidbootstrap.BetaApi;
import com.beardedhen.androidbootstrap.BootstrapDrawableFactory;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapBrand;
import com.beardedhen.androidbootstrap.utils.DimenUtils;
import com.beardedhen.androidbootstrap.utils.ViewUtils;
import java.util.concurrent.atomic.AtomicInteger;

@BetaApi
public class BootstrapAlert
extends RelativeLayout
implements Animation.AnimationListener {
    private ImageView closeButton;
    private BootstrapBrand bootstrapBrand;
    private String strongText;
    private String messageText;
    private float baselineFontSize;
    private float baselinePadding;
    private AlphaAnimation fadeInAnimation;
    private AlphaAnimation fadeOutAnimation;
    private boolean userDismissible;
    private VisibilityChangeListener visibilityChangeListener;
    private static final AtomicInteger nextGeneratedId = new AtomicInteger(1);

    public BootstrapAlert(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapAlert(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapAlert(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialise(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapAlert);
        try {
            int typeOrdinal = a.getInt(R.styleable.BootstrapAlert_bootstrapBrand, -1);
            this.bootstrapBrand = DefaultBootstrapBrand.fromAttributeValue(typeOrdinal);
            this.strongText = a.getString(R.styleable.BootstrapAlert_strongText);
            this.messageText = a.getString(R.styleable.BootstrapAlert_messageText);
            this.userDismissible = a.getBoolean(R.styleable.BootstrapAlert_dismissible, false);
            if (this.strongText == null) {
                this.strongText = "";
            }
            if (this.messageText == null) {
                this.messageText = "";
            }
        }
        finally {
            a.recycle();
        }
        this.baselineFontSize = DimenUtils.pixelsFromSpResource(this.getContext(), R.dimen.bootstrap_button_default_font_size);
        this.baselinePadding = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_alert_paddings);
        this.setupAnimations();
        this.updateBootstrapState();
    }

    private void updateBootstrapState() {
        TextView alertText = new TextView(this.getContext());
        this.closeButton = new ImageView(this.getContext());
        if (Build.VERSION.SDK_INT < 17) {
            alertText.setId(this.generateViewUniqueId());
            this.closeButton.setId(this.generateViewUniqueId());
        } else {
            alertText.setId(View.generateViewId());
            this.closeButton.setId(View.generateViewId());
        }
        RelativeLayout.LayoutParams textParams = new RelativeLayout.LayoutParams(-1, -2);
        RelativeLayout.LayoutParams closeParams = new RelativeLayout.LayoutParams(-2, -2);
        textParams.addRule(0, this.closeButton.getId());
        closeParams.addRule(11, -1);
        alertText.setLayoutParams((ViewGroup.LayoutParams)textParams);
        alertText.setTextSize(this.baselineFontSize);
        alertText.setGravity(0x800003);
        alertText.setTextColor(BootstrapDrawableFactory.bootstrapButtonText(this.getContext(), true, this.bootstrapBrand));
        alertText.setText((CharSequence)Html.fromHtml((String)String.format("<b>%s</b>%s", this.strongText, this.strongText.length() > 0 ? "&nbsp;" + this.messageText : this.messageText)));
        this.closeButton.setLayoutParams((ViewGroup.LayoutParams)closeParams);
        StateListDrawable buttonBg = BootstrapDrawableFactory.bootstrapAlertCloseIcon(this.getContext(), (int)this.baselineFontSize, (int)this.baselineFontSize, DimenUtils.dpToPixels(6.0f));
        ViewUtils.setBackgroundDrawable((View)this.closeButton, (Drawable)buttonBg);
        Drawable bg = BootstrapDrawableFactory.bootstrapAlert(this.getContext(), this.bootstrapBrand);
        ViewUtils.setBackgroundDrawable((View)this, bg);
        this.addView((View)alertText);
        if (this.userDismissible) {
            this.addView((View)this.closeButton);
            ((View)this.closeButton.getParent()).post(new Runnable(){

                @Override
                public void run() {
                    Rect bounds = new Rect();
                    BootstrapAlert.this.closeButton.getHitRect(bounds);
                    bounds.top -= DimenUtils.dpToPixels(6.0f);
                    bounds.bottom += DimenUtils.dpToPixels(6.0f);
                    bounds.left -= DimenUtils.dpToPixels(6.0f);
                    bounds.right += DimenUtils.dpToPixels(6.0f);
                    TouchDelegate touchDelegate = new TouchDelegate(bounds, (View)BootstrapAlert.this.closeButton);
                    if (View.class.isInstance(BootstrapAlert.this.closeButton.getParent())) {
                        ((View)BootstrapAlert.this.closeButton.getParent()).setTouchDelegate(touchDelegate);
                    }
                }
            });
            this.closeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BootstrapAlert.this.dismiss(true);
                }
            });
        }
        int vert = (int)((double)this.baselinePadding * 1.5);
        int hori = (int)((double)this.baselinePadding * 1.5);
        this.setPadding(hori, vert, hori, vert);
    }

    private void setupAnimations() {
        this.fadeInAnimation = new AlphaAnimation(0.0f, 1.0f);
        this.fadeInAnimation.setDuration(300L);
        this.fadeInAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        this.fadeInAnimation.setAnimationListener((Animation.AnimationListener)this);
        this.fadeOutAnimation = new AlphaAnimation(1.0f, 0.0f);
        this.fadeOutAnimation.setDuration(300L);
        this.fadeOutAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        this.fadeOutAnimation.setAnimationListener((Animation.AnimationListener)this);
    }

    public void dismiss(boolean animated) {
        if (animated) {
            if (this.visibilityChangeListener != null) {
                this.visibilityChangeListener.onAlertDismissStarted(this);
            }
            this.startAnimation((Animation)this.fadeOutAnimation);
        } else {
            this.setVisibility(8);
        }
    }

    public void show(boolean animated) {
        if (animated) {
            if (this.visibilityChangeListener != null) {
                this.visibilityChangeListener.onAlertAppearStarted(this);
            }
            this.startAnimation((Animation)this.fadeInAnimation);
        } else {
            this.setVisibility(0);
        }
    }

    public boolean isUserDismissible() {
        return this.userDismissible;
    }

    public void setUserDismissible(boolean userDismissible) {
        this.userDismissible = userDismissible;
        this.updateBootstrapState();
    }

    public void setVisibilityChangeListener(VisibilityChangeListener visibilityChangeListener) {
        this.visibilityChangeListener = visibilityChangeListener;
    }

    private int generateViewUniqueId() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = nextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!nextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.visibilityChangeListener != null) {
            if (8 == visibility) {
                this.visibilityChangeListener.onAlertDismissCompletion(this);
            } else if (0 == visibility) {
                this.visibilityChangeListener.onAlertAppearCompletion(this);
            }
        }
    }

    public void onAnimationStart(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
        if (animation == this.fadeInAnimation) {
            this.setVisibility(0);
        } else if (animation == this.fadeOutAnimation) {
            this.setVisibility(8);
        } else {
            throw new IllegalStateException("Unsupported animation attempted to use this listener");
        }
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public static interface VisibilityChangeListener {
        public void onAlertDismissStarted(BootstrapAlert var1);

        public void onAlertDismissCompletion(BootstrapAlert var1);

        public void onAlertAppearStarted(BootstrapAlert var1);

        public void onAlertAppearCompletion(BootstrapAlert var1);
    }
}

