/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.TextView;
import com.beardedhen.androidbootstrap.BootstrapText;
import com.beardedhen.androidbootstrap.IconResolver;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.TypefaceProvider;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapBrand;
import com.beardedhen.androidbootstrap.api.view.BootstrapBrandView;
import com.beardedhen.androidbootstrap.api.view.BootstrapTextView;
import com.beardedhen.androidbootstrap.font.IconSet;
import java.io.Serializable;

public class AwesomeTextView
extends TextView
implements BootstrapTextView,
BootstrapBrandView {
    private static final String TAG = "com.beardedhen.androidbootstrap.AwesomeTextView";
    private BootstrapText bootstrapText;
    private BootstrapBrand bootstrapBrand;

    public AwesomeTextView(Context context) {
        super(context);
        this.initialise(null);
    }

    public AwesomeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public AwesomeTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise(AttributeSet attrs) {
        String markdownText;
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.AwesomeTextView);
        try {
            int typeOrdinal = a.getInt(R.styleable.AwesomeTextView_bootstrapBrand, -1);
            int faIconOrdinal = a.getInt(R.styleable.AwesomeTextView_fontAwesomeIcon, -1);
            int typiconOrdinal = a.getInt(R.styleable.AwesomeTextView_typicon, -1);
            int materialIconOrdinal = a.getInt(R.styleable.AwesomeTextView_materialIcon, -1);
            boolean clickable = a.getBoolean(R.styleable.AwesomeTextView_android_clickable, true);
            this.bootstrapBrand = DefaultBootstrapBrand.fromAttributeValue(typeOrdinal);
            boolean editMode = this.isInEditMode();
            if (typiconOrdinal != -1) {
                IconSet typicon = TypefaceProvider.retrieveRegisteredIconSet("typicons-v207.ttf", editMode);
                if (!editMode) {
                    this.setIcon(typicon.iconCodeForAttrIndex(typiconOrdinal), typicon);
                }
            }
            if (faIconOrdinal != -1) {
                IconSet fontAwesome = TypefaceProvider.retrieveRegisteredIconSet("fontawesome-webfont-v450.ttf", editMode);
                if (!editMode) {
                    this.setIcon(fontAwesome.iconCodeForAttrIndex(faIconOrdinal), fontAwesome);
                }
            }
            if (materialIconOrdinal != -1) {
                IconSet materialIcons = TypefaceProvider.retrieveRegisteredIconSet("MaterialIcons-Regular.ttf", editMode);
                if (!editMode) {
                    this.setIcon(materialIcons.iconCodeForAttrIndex(materialIconOrdinal), materialIcons);
                }
            }
            markdownText = a.getString(R.styleable.AwesomeTextView_bootstrapText);
            this.setClickable(clickable);
            int gravity = a.getInt(R.styleable.AwesomeTextView_android_gravity, 17);
            this.setGravity(gravity);
        }
        finally {
            a.recycle();
        }
        if (markdownText != null) {
            this.setMarkdownText(markdownText);
        }
        this.updateBootstrapState();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(TAG, super.onSaveInstanceState());
        bundle.putSerializable("com.beardedhen.androidbootstrap.BootstrapText", (Serializable)this.bootstrapText);
        bundle.putSerializable("BootstrapBrand", (Serializable)this.bootstrapBrand);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            Serializable text = bundle.getSerializable("com.beardedhen.androidbootstrap.BootstrapText");
            Serializable brand = bundle.getSerializable("BootstrapBrand");
            if (brand instanceof BootstrapBrand) {
                this.bootstrapBrand = (BootstrapBrand)brand;
            }
            if (text instanceof BootstrapText) {
                this.bootstrapText = (BootstrapText)text;
            }
            state = bundle.getParcelable(TAG);
        }
        super.onRestoreInstanceState(state);
        this.updateBootstrapState();
    }

    public void startFlashing(boolean forever, AnimationSpeed speed) {
        AlphaAnimation fadeIn = new AlphaAnimation(0.0f, 1.0f);
        fadeIn.setDuration(50L);
        fadeIn.setRepeatMode(2);
        fadeIn.setRepeatCount(0);
        if (forever) {
            fadeIn.setRepeatCount(-1);
        }
        fadeIn.setStartOffset(speed.getFlashDuration());
        this.startAnimation((Animation)fadeIn);
    }

    public void startRotate(boolean clockwise, AnimationSpeed speed) {
        RotateAnimation rotate = clockwise ? new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f) : new RotateAnimation(360.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        rotate.setRepeatCount(-1);
        rotate.setInterpolator((Interpolator)new LinearInterpolator());
        rotate.setStartOffset(0L);
        rotate.setRepeatMode(1);
        rotate.setDuration(speed.getRotateDuration());
        this.startAnimation((Animation)rotate);
    }

    public void setIcon(CharSequence iconCode, IconSet iconSet) {
        this.setBootstrapText(new BootstrapText.Builder(this.getContext(), this.isInEditMode()).addIcon(iconCode, iconSet).build());
    }

    public void setFontAwesomeIcon(CharSequence iconCode) {
        this.setBootstrapText(new BootstrapText.Builder(this.getContext(), this.isInEditMode()).addFontAwesomeIcon(iconCode).build());
    }

    public void setMaterialIcon(CharSequence iconCode) {
        this.setBootstrapText(new BootstrapText.Builder(this.getContext(), this.isInEditMode()).addMaterialIcon(iconCode).build());
    }

    public void setTypicon(CharSequence iconCode) {
        this.setBootstrapText(new BootstrapText.Builder(this.getContext(), this.isInEditMode()).addTypicon(iconCode).build());
    }

    @Override
    public void setMarkdownText(String text) {
        this.setBootstrapText(IconResolver.resolveMarkdown(this.getContext(), text, this.isInEditMode()));
    }

    protected void updateBootstrapState() {
        if (this.bootstrapText != null) {
            this.setText((CharSequence)((Object)this.bootstrapText));
        }
        if (this.bootstrapBrand != null) {
            this.setTextColor(this.bootstrapBrand.defaultFill(this.getContext()));
        }
    }

    @Override
    public void setBootstrapText(BootstrapText bootstrapText) {
        this.bootstrapText = bootstrapText;
        this.updateBootstrapState();
    }

    @Override
    @Nullable
    public BootstrapText getBootstrapText() {
        return this.bootstrapText;
    }

    @Override
    public void setBootstrapBrand(@NonNull BootstrapBrand bootstrapBrand) {
        this.bootstrapBrand = bootstrapBrand;
        this.updateBootstrapState();
    }

    @Override
    @NonNull
    public BootstrapBrand getBootstrapBrand() {
        return this.bootstrapBrand;
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        this.bootstrapText = null;
    }

    public static enum AnimationSpeed {
        FAST(500L, 200L),
        MEDIUM(1000L, 500L),
        SLOW(2000L, 1000L);

        private final long rotateDuration;
        private final long flashDuration;

        private AnimationSpeed(long rotateDuration, long flashDuration) {
            this.rotateDuration = rotateDuration;
            this.flashDuration = flashDuration;
        }

        public long getRotateDuration() {
            return this.rotateDuration;
        }

        public long getFlashDuration() {
            return this.flashDuration;
        }
    }
}

