/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.jasn1.ber.types.string;

import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.types.BerOctetString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class BerUTF8String
extends BerOctetString {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 0, 12);

    public BerUTF8String() {
    }

    public BerUTF8String(byte[] value) {
        this.value = value;
    }

    public BerUTF8String(String valueAsString) throws UnsupportedEncodingException {
        this.value = valueAsString.getBytes("UTF-8");
    }

    @Override
    public String toString() {
        try {
            return new String(this.value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "Unsupported Encoding";
        }
    }

    @Override
    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        int codeLength = super.encode(reverseOS, false);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        return codeLength += super.decode(is, false);
    }
}

