/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.jasn1.ber;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ReverseByteArrayOutputStream
extends OutputStream {
    public byte[] buffer;
    public int index;
    private final boolean automaticResize;

    public ReverseByteArrayOutputStream(int bufferSize) {
        this(new byte[bufferSize], bufferSize - 1, false);
    }

    public ReverseByteArrayOutputStream(int bufferSize, boolean automaticResize) {
        this(new byte[bufferSize], bufferSize - 1, automaticResize);
    }

    public ReverseByteArrayOutputStream(byte[] buffer) {
        this(buffer, buffer.length - 1, false);
    }

    public ReverseByteArrayOutputStream(byte[] buffer, int startingIndex) {
        this(buffer, startingIndex, false);
    }

    public ReverseByteArrayOutputStream(byte[] buffer, int startingIndex, boolean automaticResize) {
        if (buffer.length <= 0) {
            throw new IllegalArgumentException("buffer size may not be <= 0");
        }
        this.buffer = buffer;
        this.index = startingIndex;
        this.automaticResize = automaticResize;
    }

    @Override
    public void write(int arg0) throws IOException {
        this.write((byte)arg0);
    }

    public void write(byte arg0) throws IOException {
        try {
            this.buffer[this.index] = arg0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.automaticResize) {
                this.resize();
                this.buffer[this.index] = arg0;
            }
            throw new ArrayIndexOutOfBoundsException("buffer.length = " + this.buffer.length);
        }
        --this.index;
    }

    private void resize() {
        byte[] newBuffer = new byte[this.buffer.length * 2];
        System.arraycopy(this.buffer, this.index + 1, newBuffer, this.buffer.length + this.index + 1, this.buffer.length - this.index - 1);
        this.index += this.buffer.length;
        this.buffer = newBuffer;
    }

    @Override
    public void write(byte[] byteArray) throws IOException {
        for (int i = byteArray.length - 1; i >= 0; --i) {
            try {
                this.buffer[this.index] = byteArray[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (this.automaticResize) {
                    this.resize();
                    this.buffer[this.index] = byteArray[i];
                }
                throw new ArrayIndexOutOfBoundsException("buffer.length = " + this.buffer.length);
            }
            --this.index;
        }
    }

    public byte[] getArray() {
        if (this.index == -1) {
            return this.buffer;
        }
        int subBufferLength = this.buffer.length - this.index - 1;
        byte[] subBuffer = new byte[subBufferLength];
        System.arraycopy(this.buffer, this.index + 1, subBuffer, 0, subBufferLength);
        return subBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.buffer, this.index + 1, this.buffer.length - (this.index + 1));
    }

    public void reset() {
        this.index = this.buffer.length - 1;
    }
}

