/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.jasn1.ber;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class BerLength
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int val;

    public int decode(InputStream is) throws IOException {
        this.val = is.read();
        if (this.val == -1) {
            throw new EOFException("Unexpected end of input stream.");
        }
        if ((this.val & 0x80) == 0) {
            return 1;
        }
        int lengthLength = this.val & 0x7F;
        if (lengthLength == 0) {
            this.val = -1;
            return 1;
        }
        if (lengthLength > 4) {
            throw new IOException("Length is out of bound!");
        }
        this.val = 0;
        for (int i = 0; i < lengthLength; ++i) {
            int nextByte = is.read();
            if (nextByte == -1) {
                throw new EOFException("Unexpected end of input stream.");
            }
            this.val |= nextByte << 8 * (lengthLength - i - 1);
        }
        return lengthLength + 1;
    }

    public static int skip(InputStream is) throws IOException {
        int val = is.read();
        if (val == -1) {
            throw new EOFException("Unexpected end of input stream.");
        }
        if ((val & 0x80) == 0) {
            return 1;
        }
        int lengthLength = val & 0x7F;
        if (lengthLength == 0) {
            val = -1;
            return 1;
        }
        if (lengthLength > 4) {
            throw new IOException("Length is out of bound!");
        }
        for (int i = 0; i < lengthLength; ++i) {
            int nextByte = is.read();
            if (nextByte != -1) continue;
            throw new EOFException("Unexpected end of input stream.");
        }
        return lengthLength + 1;
    }

    public static int encodeLength(OutputStream reverseOS, int length) throws IOException {
        if (length <= 127) {
            reverseOS.write((byte)length);
            return 1;
        }
        int numLengthBytes = 1;
        while ((int)(Math.pow(2.0, 8 * numLengthBytes) - 1.0) < length) {
            ++numLengthBytes;
        }
        for (int i = 0; i < numLengthBytes; ++i) {
            reverseOS.write(length >> 8 * i & 0xFF);
        }
        reverseOS.write(0x80 | numLengthBytes);
        return 1 + numLengthBytes;
    }
}

