/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import com.beaconsinspace.android.beacon.detector.deviceatlas.CameraProperties;
import com.beaconsinspace.android.beacon.detector.deviceatlas.CpuProperties;
import com.beaconsinspace.android.beacon.detector.deviceatlas.DataCollector;
import com.beaconsinspace.android.beacon.detector.deviceatlas.DisplayProperties;
import com.beaconsinspace.android.beacon.detector.deviceatlas.GpuLoader;
import com.beaconsinspace.android.beacon.detector.deviceatlas.MemoryProperties;
import com.beaconsinspace.android.beacon.detector.deviceatlas.Properties;
import com.beaconsinspace.android.beacon.detector.deviceatlas.SensorProperties;
import com.beaconsinspace.android.beacon.detector.deviceatlas.StorageProperties;
import com.beaconsinspace.android.beacon.detector.deviceatlas.StrUtil;
import com.beaconsinspace.android.beacon.detector.deviceatlas.TelephonyProperties;
import com.beaconsinspace.android.beacon.detector.deviceatlas.UsbProperties;
import com.beaconsinspace.android.beacon.detector.deviceatlas.WebPropertiesLoader;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.json.JSONException;
import org.json.JSONObject;

public class DataCollectorTask
implements Callable<Void> {
    private static final String TAG = DataCollectorTask.class.getName();
    protected static final String BUILD = "build";
    protected static final String BUILD_VERSION = "buildVersion";
    protected static final String WEB = "web";
    protected static final String CPU = "cpu";
    protected static final String MEMORY = "memory";
    protected static final String GPU = "gpu";
    protected static final String TELEPHONY = "telephony";
    protected static final String STORAGE = "storage";
    protected static final String SENSORS = "sensors";
    protected static final String DISPLAY = "display";
    protected static final String USB = "usb";
    protected static final String CAMERA = "camera";
    private DataCollector master;
    private Activity activityContext;
    private boolean gpuComplete = false;
    private boolean webComplete = false;

    public DataCollectorTask(Activity activityContext, DataCollector master) {
        this.activityContext = activityContext;
        this.master = master;
    }

    @Override
    public Void call() throws JSONException, InterruptedException {
        WebPropertiesLoader webLoader = new WebPropertiesLoader(this.activityContext);
        this.master.addProperties(BUILD, this.getBuildProperties());
        this.master.addProperties(BUILD_VERSION, this.getBuildVersionProperties());
        this.master.addProperties(CPU, CpuProperties.getProperties());
        this.master.addProperties(MEMORY, MemoryProperties.getProperties());
        this.master.addProperties(DISPLAY, DisplayProperties.getProperties((Context)this.activityContext));
        this.master.addProperties(TELEPHONY, TelephonyProperties.getProperties((Context)this.activityContext));
        this.master.addProperties(STORAGE, StorageProperties.getProperties());
        this.master.addProperties(USB, UsbProperties.getProperties());
        this.master.addProperties(CAMERA, CameraProperties.getProperties((Context)this.activityContext));
        this.master.addProperties(SENSORS, SensorProperties.getProperties((Context)this.activityContext));
        this.handleAsyncGpuData();
        this.handleAsyncWebData(webLoader);
        while (!this.gpuComplete || !this.webComplete) {
            StringBuilder sb = new StringBuilder();
            sb.append("Waiting for");
            if (!this.gpuComplete) {
                sb.append(" GPU");
            }
            if (!this.webComplete) {
                sb.append(" WEB");
            }
            sb.append(" data...");
            Thread.sleep(100L);
        }
        return null;
    }

    private void handleAsyncGpuData() {
        GpuLoader gpuLoader = new GpuLoader();
        gpuLoader.load(this.activityContext, new AsyncResponse(){

            @Override
            public void completed(Properties props) {
                try {
                    DataCollectorTask.this.master.addProperties(DataCollectorTask.GPU, props.getProperties());
                }
                catch (JSONException jSONException) {
                }
                finally {
                    DataCollectorTask.this.gpuComplete = true;
                }
            }

            @Override
            public void partial(Properties props) {
            }
        });
    }

    private void handleAsyncWebData(WebPropertiesLoader webProperties) {
        webProperties.load(new AsyncResponse(){

            @Override
            public void completed(Properties props) {
                try {
                    DataCollectorTask.this.master.addProperties(DataCollectorTask.WEB, props.getProperties());
                }
                catch (JSONException jSONException) {
                }
                finally {
                    DataCollectorTask.this.webComplete = true;
                }
            }

            @Override
            public void partial(Properties props) {
                try {
                    DataCollectorTask.this.master.addProperties(DataCollectorTask.WEB, props.getProperties());
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        });
    }

    private JSONObject getBuildProperties() throws JSONException {
        Field[] fields = Build.class.getDeclaredFields();
        return this.getPropertiesFromFields(fields, null);
    }

    private JSONObject getBuildVersionProperties() throws JSONException {
        Field[] fields = Build.VERSION.class.getDeclaredFields();
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("SDK");
        return this.getPropertiesFromFields(fields, exclude);
    }

    private JSONObject getPropertiesFromFields(Field[] fields, Set<String> exclude) throws JSONException {
        JSONObject props = new JSONObject();
        for (Field field : fields) {
            String key = field.getName();
            if (exclude != null && exclude.contains(key)) continue;
            try {
                key = StrUtil.toCamelCase(field.getName());
                String value = StrUtil.asString(field.get(key));
                props.put(key, (Object)value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return props;
    }

    static interface AsyncResponse {
        public void completed(Properties var1);

        public void partial(Properties var1);
    }
}

