/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISDetectorRSSICollector;
import java.util.Date;
import org.altbeacon.beacon.Beacon;

public class BISCollectionEvent {
    public Date date;
    public Location location;
    public Beacon beacon;
    public BISDetectorRSSICollector beaconRssiCollector;
    public BISCollectionEventType eventType;
    public BISCollectionEventDirection eventDirection;
    public BISDetector.ApplicationState applicationState = BISDetector.ApplicationState.BACKGROUND;
    public float batteryLevel;
    public String batteryState;

    public BISCollectionEvent(Context context, BISCollectionEventType eventType, BISDetector.ApplicationState applicationState) {
        this.date = new Date();
        this.eventType = eventType;
        this.applicationState = applicationState;
        this.powerCheck(context);
    }

    public BISCollectionEvent(Context context, BISCollectionEventType eventType, BISDetector.ApplicationState applicationState, Location location) {
        this.date = new Date();
        this.eventType = eventType;
        this.location = location;
        this.applicationState = applicationState;
        this.powerCheck(context);
    }

    public BISCollectionEvent(Context context, BISCollectionEventType eventType, BISDetector.ApplicationState applicationState, BISCollectionEventDirection eventDirection, Location location) {
        this.date = new Date();
        this.eventType = eventType;
        this.eventDirection = eventDirection;
        this.location = location;
        this.applicationState = applicationState;
        this.powerCheck(context);
    }

    public BISCollectionEvent(Context context, BISCollectionEventType eventType, BISDetector.ApplicationState applicationState, BISCollectionEventDirection eventDirection, Beacon beacon) {
        this.date = new Date();
        this.eventType = eventType;
        this.eventDirection = eventDirection;
        this.beacon = beacon;
        this.applicationState = applicationState;
        this.powerCheck(context);
    }

    public BISCollectionEvent(Context context, BISCollectionEventType eventType, BISDetector.ApplicationState applicationState, BISCollectionEventDirection eventDirection, Beacon beacon, BISDetectorRSSICollector beaconRssiCollector) {
        this.date = new Date();
        this.eventType = eventType;
        this.eventDirection = eventDirection;
        this.beacon = beacon;
        this.beaconRssiCollector = beaconRssiCollector;
        this.applicationState = applicationState;
        this.powerCheck(context);
    }

    private void powerCheck(Context context) {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = context.registerReceiver(null, ifilter);
            int status = batteryStatus.getIntExtra("status", -1);
            switch (status) {
                case 2: {
                    this.batteryState = "charging";
                    break;
                }
                case 4: {
                    this.batteryState = "notcharging";
                    break;
                }
                case 3: {
                    this.batteryState = "unplugged";
                    break;
                }
                case 5: {
                    this.batteryState = "full";
                    break;
                }
                default: {
                    this.batteryState = "unknown";
                }
            }
            int level = batteryStatus.getIntExtra("level", -1);
            int scale = batteryStatus.getIntExtra("scale", -1);
            this.batteryLevel = (float)level / (float)scale;
        }
        catch (Exception e) {
            this.batteryState = "unknown";
            this.batteryLevel = 0.0f;
        }
    }

    public boolean equals(Object o) {
        boolean same = true;
        if (o.getClass().equals(BISCollectionEvent.class)) {
            BISCollectionEvent other = (BISCollectionEvent)o;
            if (other.date != this.date) {
                return false;
            }
            if (other.eventDirection != this.eventDirection) {
                return false;
            }
            if (other.eventType != this.eventType) {
                return false;
            }
            if (other.location != this.location) {
                return false;
            }
        }
        return same;
    }

    public String getDetect() {
        if (this.eventDirection != null) {
            switch (this.eventDirection) {
                case Enter: {
                    return "enter";
                }
                case Exit: {
                    return "exit";
                }
                case Dwell: {
                    return "dwell";
                }
            }
        }
        return "gps";
    }

    public String getEventType() {
        switch (this.eventType) {
            case SLC: {
                return "slc";
            }
            case Visit: {
                return "visit";
            }
            case BeaconInteraction: {
                return "beaconinteraction";
            }
            case GeoFence: {
                return "geofence";
            }
        }
        return "gps";
    }

    public String getUniqueId() {
        String uniqueId = this.getDetect() + "_" + this.getEventType();
        if (this.location != null) {
            uniqueId = uniqueId + "_" + this.location.getLatitude() + "," + this.location.getLongitude();
        }
        if (this.beacon != null) {
            uniqueId = uniqueId + "_";
            Integer numIdentifiers = this.beacon.getIdentifiers().size();
            if (numIdentifiers >= 1) {
                uniqueId = uniqueId + this.beacon.getId1() + "_";
            }
            if (numIdentifiers >= 2) {
                uniqueId = uniqueId + this.beacon.getId2() + "_";
            }
            if (numIdentifiers >= 3) {
                uniqueId = uniqueId + this.beacon.getId3();
            }
        }
        return uniqueId;
    }

    public static enum BISCollectionEventDirection {
        None,
        Enter,
        Exit,
        Dwell;

    }

    public static enum BISCollectionEventType {
        SLC,
        Visit,
        BeaconInteraction,
        GeoFence,
        GPS;

    }
}

