/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.beaconsinspace.android.beacon.detector.deviceatlas.DataCollectorTask;
import com.beaconsinspace.android.beacon.detector.deviceatlas.WebProperties;
import java.lang.reflect.Constructor;

public class WebPropertiesLoader {
    private static final String TAG = WebPropertiesLoader.class.getName();
    private final Activity activityContext;

    public WebPropertiesLoader(Activity activityContext) {
        this.activityContext = activityContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(DataCollectorTask.AsyncResponse callback) {
        callback.partial(new WebProperties());
        String ua = null;
        if (Build.VERSION.SDK_INT >= 17) {
            ua = WebSettings.getDefaultUserAgent((Context)this.activityContext);
        } else {
            Constructor constructor = null;
            try {
                constructor = WebSettings.class.getDeclaredConstructor(Context.class, WebView.class);
                constructor.setAccessible(true);
                WebSettings settings = (WebSettings)constructor.newInstance(this.activityContext, null);
                ua = settings.getUserAgentString();
            }
            catch (Exception exception) {
            }
            finally {
                if (constructor != null) {
                    constructor.setAccessible(false);
                }
            }
        }
        if (ua != null) {
            WebProperties props = new WebProperties();
            props.setWebviewUserAgent(ua);
            callback.completed(props);
        } else {
            this.createWebViewForUa(callback);
        }
    }

    private void createWebViewForUa(final DataCollectorTask.AsyncResponse callback) {
        this.activityContext.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String ua = null;
                try {
                    WebView webview = new WebView((Context)WebPropertiesLoader.this.activityContext);
                    ua = webview.getSettings().getUserAgentString();
                    webview.clearHistory();
                    webview.clearCache(true);
                    webview.freeMemory();
                    webview.pauseTimers();
                    webview.destroy();
                    webview = null;
                }
                catch (Exception props) {
                }
                finally {
                    if (ua != null) {
                        // empty if block
                    }
                    WebProperties props = new WebProperties();
                    props.setWebviewUserAgent(ua);
                    callback.completed(props);
                }
            }
        });
    }
}

