/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.Context;
import android.content.SharedPreferences;

class BISPersistentStorage {
    private static final String sharedPreferencesFile = "d97470b5-491e-49db-b200-156dbadca98e";
    private static final String KEY_IS_DEVICE_METADATA_COLLECTED = "KEY_IS_DEVICE_METADATA_COLLECTED";
    static final String KEY_APIKEY = "BIS_API_KEY";
    static final String KEY_DEVICE_METADATA = "KEY_DEVICEATLAS_DATA";
    static final String KEY_BIS_CONFIGURATION_JSON = "KEY_BIS_CONFIGURATION_JSON";
    static final String KEY_BIS_CONFIGURATION_MILLISECONDS_SINCE_LAST_STORED = "KEY_BIS_CONFIGURATION_MILLISECONDS_SINCE_LAST_STORED";
    private static final String KEY_IS_DEVICE_METADATA_SENT = "KEY_IS_DEVICE_METADATA_SENT";
    private SharedPreferences sharedPreferences;

    public BISPersistentStorage(Context context) {
        this.sharedPreferences = context.getSharedPreferences(sharedPreferencesFile, 0);
    }

    public void storeString(String key, String value) {
        SharedPreferences.Editor sharedPreferencesEditor = this.sharedPreferences.edit();
        sharedPreferencesEditor.putString(key, value);
        sharedPreferencesEditor.commit();
    }

    public String getString(String key) {
        return this.sharedPreferences.getString(key, null);
    }

    public boolean isdeviceMetaDataSent() {
        return this.sharedPreferences.getBoolean(KEY_IS_DEVICE_METADATA_SENT, false);
    }

    public void setDeviceMetaDataSent(boolean isDataSent) {
        this.sharedPreferences.edit().putBoolean(KEY_IS_DEVICE_METADATA_SENT, isDataSent).commit();
    }

    public boolean isDeviceMetaDataCollected() {
        return this.sharedPreferences.getBoolean(KEY_IS_DEVICE_METADATA_COLLECTED, false);
    }

    public void setDeviceMetaDataCollected(boolean isDeviceMetaDataCollected) {
        this.sharedPreferences.edit().putBoolean(KEY_IS_DEVICE_METADATA_COLLECTED, isDeviceMetaDataCollected).commit();
    }

    public String getDeviceMetaDataString() {
        return this.getString(KEY_DEVICE_METADATA);
    }

    public void storeDeviceMetaData(String jsonStr) {
        this.storeString(KEY_DEVICE_METADATA, jsonStr);
    }
}

