/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISCollectionEvent;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISException;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISNetworking;
import com.beaconsinspace.android.beacon.detector.BISNetworkingThread;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.utils.UrlBeaconUrlCompressor;

public class BISNetworkingEventsThread
extends BISNetworkingThread<List<BISCollectionEvent>> {
    private final String apiUrl;
    private final String bisData;
    private final BISDetector detector;
    private final List<BISCollectionEvent> events;
    public static final int STATUS_SUCCESS = 200;
    private static final String TAG = "BIS_NETWORK_EVENTS";

    public BISNetworkingEventsThread(BISDetector detector, String apiUrl, String bisData, List<BISCollectionEvent> events) {
        this.apiUrl = apiUrl;
        this.bisData = bisData;
        this.detector = detector;
        this.events = events;
    }

    @Override
    public void run() {
        block11: {
            ArrayList<String> eventsData = new ArrayList<String>();
            String authorizationHeader = BISNetworking.getAuthorizationHeader(this.detector);
            for (BISCollectionEvent event : this.events) {
                if (event == null) continue;
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.putAll(BISNetworking.getCommonRequestArguments(this.detector));
                parameters.putAll(BISNetworking.getLocationRequestArguments(event.location));
                parameters.putAll(this.getEventArguments(event));
                String eventData = BISNetworking.encodeParams(parameters);
                String encoded = null;
                try {
                    encoded = Base64.encodeToString((byte[])eventData.getBytes("UTF-8"), (int)2);
                    eventsData.add(encoded);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            String data = TextUtils.join((CharSequence)"|", eventsData);
            try {
                HttpURLConnection urlConnection = (HttpURLConnection)new URL(this.apiUrl).openConnection();
                urlConnection.setDoOutput(true);
                urlConnection.setRequestProperty("Authorization", authorizationHeader);
                if (this.bisData != null) {
                    urlConnection.setRequestProperty("bisData", this.bisData);
                }
                urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                urlConnection.setRequestProperty("Accept", "application/json");
                urlConnection.setRequestMethod("POST");
                urlConnection.connect();
                OutputStream outputStream = urlConnection.getOutputStream();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                writer.write(data);
                writer.close();
                outputStream.close();
                int response = urlConnection.getResponseCode();
                if (response == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    reader.close();
                    if (this.listener != null) {
                        this.listener.onSuccess(this.events);
                    }
                } else {
                    Log.i((String)TAG, (String)("STATUS_CODE is " + response));
                    if (this.listener != null) {
                        this.listener.onError(new BISException("Could not post events"));
                    }
                }
            }
            catch (Throwable t) {
                if (this.listener == null) break block11;
                this.listener.onError(t);
            }
        }
    }

    private Map<String, String> getEventArguments(BISCollectionEvent event) {
        HashMap<String, String> request = new HashMap<String, String>();
        if (event != null) {
            request.put("detect", event.getDetect());
            request.put("eventType", event.getEventType());
            request.put("batteryLevel", Float.toString(event.batteryLevel));
            request.put("batteryState", event.batteryState);
            if (event.date != null) {
                request.put("creationTimeInEpochMillis", String.valueOf(event.date.getTime()));
            }
            String applicationState = "background";
            if (event.applicationState != null) {
                switch (event.applicationState) {
                    case ACTIVE: {
                        applicationState = "active";
                        break;
                    }
                    case INACTIVE: {
                        applicationState = "inactive";
                        break;
                    }
                    default: {
                        applicationState = "background";
                    }
                }
            }
            request.put("appStateDetection", applicationState);
            if (event.beacon != null) {
                String rssi;
                String[] identifiers = this.idsForBeacon(event.beacon);
                request.put("uuid", identifiers[0]);
                request.put("major", identifiers[1]);
                request.put("minor", identifiers[2]);
                request.put("beaconServiceUUID", String.valueOf(event.beacon.getServiceUuid()));
                request.put("beaconTxPower", String.valueOf(event.beacon.getTxPower()));
                request.put("beaconDistance", String.valueOf(event.beacon.getDistance()));
                request.put("beaconName", event.beacon.getBluetoothName());
                request.put("beaconManufacturer", String.valueOf(event.beacon.getManufacturer()));
                request.put("beaconTypeCode", String.valueOf(event.beacon.getBeaconTypeCode()));
                if (event.beacon.getServiceUuid() == 65194 && event.beacon.getBeaconTypeCode() == 16) {
                    String url = UrlBeaconUrlCompressor.uncompress((byte[])event.beacon.getId1().toByteArray());
                    request.put("beaconURL", url);
                }
                if (event.beacon.getServiceUuid() == 65194 && event.beacon.getBeaconTypeCode() == 0 && event.beacon.getExtraDataFields().size() > 0) {
                    long telemetryVersion = (Long)event.beacon.getExtraDataFields().get(0);
                    long batteryMilliVolts = (Long)event.beacon.getExtraDataFields().get(1);
                    long pduCount = (Long)event.beacon.getExtraDataFields().get(3);
                    long uptime = (Long)event.beacon.getExtraDataFields().get(4);
                    request.put("beaconTelemetryVersion", Long.toString(telemetryVersion));
                    request.put("beaconTelemetryBattery", Long.toString(batteryMilliVolts));
                    request.put("beaconTelemetryPduCount", Long.toString(pduCount));
                    request.put("beaconTelemetryUptime", Long.toString(uptime));
                }
                if (event.eventDirection != null && event.eventDirection == BISCollectionEvent.BISCollectionEventDirection.Exit && (rssi = event.beaconRssiCollector.toJson()) != null) {
                    request.put("rssi", rssi);
                }
                if (event.location != null) {
                    double dateCreatedGeographicPosition = (double)event.location.getTime() / 1000.0;
                    request.put("dateCreatedGeographicPosition", Double.toString(dateCreatedGeographicPosition));
                }
            }
        }
        return request;
    }

    private String beaconIdentifierToString(Identifier i) {
        try {
            if (i == null) {
                return null;
            }
            String s = i.toString();
            if (s == null) {
                return null;
            }
            if (s.length() >= 2 && s.substring(0, 2).equals("0x")) {
                s = s.substring(2);
            }
            return s;
        }
        catch (Exception e) {
            BISLog.e(this.getClass().getName(), "Exception: " + e.getMessage());
            return null;
        }
    }

    private String[] idsForBeacon(Beacon beacon) {
        if (beacon == null) {
            return new String[]{"", "", ""};
        }
        Identifier id1 = null;
        Identifier id2 = null;
        Identifier id3 = null;
        try {
            id1 = beacon.getIdentifiers().size() > 0 ? beacon.getId1() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            id2 = beacon.getIdentifiers().size() > 1 ? beacon.getId2() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            id3 = beacon.getIdentifiers().size() > 2 ? beacon.getId3() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String ID1 = id1 != null ? this.beaconIdentifierToString(id1) : "";
        String ID2 = id2 != null ? this.beaconIdentifierToString(id2) : "";
        String ID3 = id3 != null ? this.beaconIdentifierToString(id3) : "";
        return new String[]{ID1, ID2, ID3};
    }
}

