/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISCollectionEvent;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISDetectorBootstrapListener;
import com.beaconsinspace.android.beacon.detector.BISLog;
import java.util.ArrayList;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconParser;

public class BISBeaconReceiver
extends BroadcastReceiver {
    private static String TAG = "BISBeaconReceiver";

    public void onReceive(Context context, Intent intent) {
        boolean hasBluetoothAdmin;
        boolean hasBluetooth = ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.BLUETOOTH") == 0;
        boolean bl = hasBluetoothAdmin = ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.BLUETOOTH_ADMIN") == 0;
        if (!hasBluetooth) {
            BISLog.d(((Object)((Object)this)).getClass().getName(), "BISBeaconReceiver() BLUETOOTH not granted");
            return;
        }
        if (!hasBluetoothAdmin) {
            BISLog.d(((Object)((Object)this)).getClass().getName(), "BISBeaconReceiver() BLUETOOTH_ADMIN not granted");
            return;
        }
        try {
            int bleCallbackType;
            if (Build.VERSION.SDK_INT >= 26 && (bleCallbackType = intent.getIntExtra("android.bluetooth.le.extra.CALLBACK_TYPE", -1)) != -1) {
                BISLog.d(TAG, "Passive background scan callback type: " + bleCallbackType);
                final ArrayList scanResults = intent.getParcelableArrayListExtra("android.bluetooth.le.extra.LIST_SCAN_RESULT");
                final BISDetector bisDetector = new BISDetector(context);
                bisDetector.contextDescription = "BISBeaconReceiver";
                bisDetector.bootstrap(new BISDetectorBootstrapListener(){

                    @Override
                    public void onBootstrapSuccess(BISDetector detector) {
                        final BISCollectionManager collectionManager = bisDetector.getCollectionManager();
                        if (collectionManager != null) {
                            final BroadcastReceiver.PendingResult result = BISBeaconReceiver.this.goAsync();
                            final Context theContext = bisDetector.getContext();
                            Thread thread = new Thread(){

                                @Override
                                public void run() {
                                    block4: {
                                        try {
                                            if (Build.VERSION.SDK_INT >= 26) {
                                                for (ScanResult scanResult : scanResults) {
                                                    BeaconParser parser = new BeaconParser();
                                                    Beacon beacon = parser.fromScanData(scanResult.getScanRecord().getBytes(), scanResult.getRssi(), scanResult.getDevice());
                                                    BISCollectionEvent event = new BISCollectionEvent(theContext, BISCollectionEvent.BISCollectionEventType.BeaconInteraction, bisDetector.applicationState, BISCollectionEvent.BISCollectionEventDirection.Enter, beacon);
                                                    event.location = collectionManager.getLastKnownLocation();
                                                    collectionManager.triggerEvent(event);
                                                }
                                                collectionManager.startLocationGathering();
                                            }
                                            result.finish();
                                        }
                                        catch (Throwable t) {
                                            if (bisDetector == null) break block4;
                                            bisDetector.reportCrash(t);
                                        }
                                    }
                                }
                            };
                            thread.start();
                        }
                    }

                    @Override
                    public void onBootstrapFailure() {
                        Log.d((String)TAG, (String)"Bootstrap failed.");
                    }
                });
            }
        }
        catch (Throwable t) {
            BISLog.e(TAG, t.getMessage());
        }
    }
}

