package com.beaconsinspace.android.beacon.detector;

import android.util.Log;

public class BISLog {

    private static final boolean LOGGING_ENABLED = false;

    public static void d(String tag, String msg){
        if(LOGGING_ENABLED){
            Log.d(tag, msg);
            callDelegate(Log.DEBUG, msg);
        }
    }

    public static void i(String tag, String msg) {
        if(LOGGING_ENABLED){
            Log.i(tag, msg);
            callDelegate(Log.INFO, msg);
        }
    }

    public static void e(String tag, String msg, Exception exception) {
        if(LOGGING_ENABLED){
            Log.e(tag, msg, exception);
            callDelegate(Log.ERROR, msg);
        }
    }

    public static void wtf(String tag, String msg){
        if(LOGGING_ENABLED){
            wtf(tag, msg, null);
            callDelegate(Log.ERROR, msg);
        }
    }

    public static void wtf(String tag, String msg, Throwable throwable) {
        if(LOGGING_ENABLED){
            Log.wtf(tag,msg,throwable);
            callDelegate(Log.ERROR, msg);
        }
    }

    public static void e(String tag, String msg) {
        if(LOGGING_ENABLED){
            Log.e(tag, msg);
            callDelegate(Log.ERROR, msg);
        }
    }

    private static void callDelegate( int logLevel, String msg){
        if (BISDetector.logDelegate != null){
            BISDetector.logDelegate.onBISLog(logLevel, msg);
        }
    }
}
