package com.beaconsinspace.android.beacon.detector;

import android.Manifest;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.util.Log;

import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconParser;

import java.util.ArrayList;

/**
 * Created by kyleshank on 10/11/17.
 */

public class BISBeaconReceiver extends BroadcastReceiver {
    private static String TAG = "BISBeaconReceiver";


    @Override
    public void onReceive(Context context, Intent intent) {
        boolean hasBluetooth = ActivityCompat.checkSelfPermission(context, Manifest.permission.BLUETOOTH) == PackageManager.PERMISSION_GRANTED;
        boolean hasBluetoothAdmin = ActivityCompat.checkSelfPermission(context, Manifest.permission.BLUETOOTH_ADMIN) == PackageManager.PERMISSION_GRANTED;

        if (!hasBluetooth) {
            BISLog.d(this.getClass().getName(), "BISBeaconReceiver() BLUETOOTH not granted");
            return;
        }

        if (!hasBluetoothAdmin) {
            BISLog.d(this.getClass().getName(), "BISBeaconReceiver() BLUETOOTH_ADMIN not granted");
            return;
        }

        final BISDetector bisDetector;
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                int bleCallbackType = intent.getIntExtra(BluetoothLeScanner.EXTRA_CALLBACK_TYPE, -1);
                if (bleCallbackType != -1) {
                    BISLog.d(TAG, "Passive background scan callback type: " + bleCallbackType);
                    final ArrayList<ScanResult> scanResults = intent.getParcelableArrayListExtra(
                            BluetoothLeScanner.EXTRA_LIST_SCAN_RESULT);

                    bisDetector = new BISDetector(context);
                    bisDetector.contextDescription = "BISBeaconReceiver";
                    bisDetector.bootstrap(new BISDetectorBootstrapListener() {
                        @Override
                        public void onBootstrapSuccess(BISDetector detector) {
                            final BISCollectionManager collectionManager = bisDetector.getCollectionManager();

                            if (collectionManager != null) {
                                final PendingResult result = goAsync();
                                final Context theContext = bisDetector.getContext();
                                Thread thread = new Thread() {
                                    public void run() {
                                        try {
                                            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                                for (ScanResult scanResult : scanResults) {
                                                    BeaconParser parser = new BeaconParser();
                                                    Beacon beacon = parser.fromScanData(
                                                            scanResult.getScanRecord().getBytes(),
                                                            scanResult.getRssi(), scanResult.getDevice());
                                                    BISCollectionEvent event = new BISCollectionEvent(
                                                            theContext,
                                                            BISCollectionEvent.BISCollectionEventType.BeaconInteraction,
                                                            bisDetector.applicationState,
                                                            BISCollectionEvent.BISCollectionEventDirection.Enter,
                                                            beacon);
                                                    event.location = collectionManager.getLastKnownLocation();
                                                    collectionManager.triggerEvent(event);
                                                }

                                                collectionManager.startLocationGathering();
                                            }
                                            result.finish();
                                        } catch (Throwable t) {
                                            if (bisDetector != null) {
                                                bisDetector.reportCrash(t);
                                            }
                                        }
                                    }
                                };
                                thread.start();
                            }
                        }

                        @Override
                        public void onBootstrapFailure() {
                            Log.d(TAG, "Bootstrap failed.");
                        }
                    });
                }
            }
        } catch (Throwable t) {
            BISLog.e(TAG,t.getMessage());
        }
    }
}
