/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.content.Intent;
import android.content.ReceiverCallNotAllowedException;
import android.content.ServiceConnection;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.app.ActivityCompat;
import com.beaconsinspace.android.beacon.detector.BISBeaconReceiver;
import com.beaconsinspace.android.beacon.detector.BISCollectionEvent;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISDetectorRSSICollector;
import com.beaconsinspace.android.beacon.detector.BISGeofenceTransitionsIntentService;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISNetworking;
import com.beaconsinspace.android.beacon.detector.BISNetworkingThreadListener;
import com.beaconsinspace.android.beacon.detector.BISReportingManager;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.startup.RegionBootstrap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BISCollectionManager
implements LocationListener,
BeaconConsumer,
Application.ActivityLifecycleCallbacks {
    private static final String TAG = "BIS_COLLECTION_MANAGER";
    private static final Long BEACON_EXIT_THRESHOLD = 30000L;
    private BISReportingManager reportingManager;
    private BISCollectionEvent lastEvent;
    private GeofencingClient mGeofencingClient;
    private PendingIntent mGeofencePendingIntent;
    private List<Geofence> mGeofenceList;
    private Location lastLocation;
    private BeaconManager beaconManager = null;
    private RegionBootstrap regionBootstrap;
    private Timer timer;
    private TimerTask timerTask;
    private Timer stickyIdleTimer;
    private TimerTask stickyIdleTimerTask;
    private boolean stickyService = false;
    private List<Timer> intervalTimers = new ArrayList<Timer>();
    private static final ConcurrentHashMap<Beacon, Long> beaconTimestampMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Beacon, BISDetectorRSSICollector> beaconRssiMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> lastTriggerEvents = new ConcurrentHashMap();
    private Timer permissionsTimer;
    private TimerTask permissionsTimerTask;
    private Timer eventCollectionFilterTimer;
    private TimerTask eventCollectionFilterTimerTask;
    private List<BISCollectionEvent> gpsBuffer = new ArrayList<BISCollectionEvent>();
    private final BISDetector detector;

    public BISCollectionManager(BISDetector detector, boolean stickyService) {
        this.detector = detector;
        this.reportingManager = new BISReportingManager(detector);
        this.beaconManager = BeaconManager.getInstanceForApplication((Context)detector.getContext());
        this.mGeofencingClient = null;
        this.mGeofenceList = new ArrayList<Geofence>();
        this.lastLocation = null;
        this.stickyService = stickyService;
        this.setupGeofencingClient();
        this.startLocationManager();
        this.startBeaconManager();
        if (detector.getContext() instanceof Application) {
            Application application = (Application)detector.getContext();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        BISLog.d(TAG, "Collection Manager started.");
    }

    private void startLocationManager() {
        this.startLocationGathering();
    }

    public Location getLastKnownLocation() {
        return this.lastLocation;
    }

    public void onLocationChanged(Location location) {
        this.lastLocation = location;
        BISCollectionEvent event = new BISCollectionEvent(this.detector.getContext(), BISCollectionEvent.BISCollectionEventType.GPS, this.detector.applicationState, location);
        this.saveGPSEvent(event);
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        BISLog.d(this.getClass().getName(), "onStatusChanged(" + provider + ")(" + status + ")");
    }

    public void onProviderEnabled(String provider) {
        BISLog.d(this.getClass().getName(), "onProviderEnabled(" + provider + ")");
    }

    public void onProviderDisabled(String provider) {
        BISLog.d(this.getClass().getName(), "onProviderDisabled(" + provider + ")");
    }

    public void triggerEvent(BISCollectionEvent event) {
        long diff;
        this.saveEvent(event);
        String uniqueId = event.getUniqueId();
        BISLog.d(this.getClass().getName(), "Triggered by event: " + uniqueId);
        boolean shouldGather = true;
        Date now = new Date();
        Long lastValue = this.lastTriggerEvents.get(uniqueId);
        if (lastValue != null && (double)(diff = now.getTime() - lastValue) < 600000.0) {
            shouldGather = false;
            BISLog.d(this.getClass().getName(), "Skipping location gathering. Similar event was trigged " + (double)diff / 1000.0 + " seconds ago.");
        }
        if (shouldGather) {
            this.lastTriggerEvents.put(uniqueId, now.getTime());
            try {
                this.startLocationGathering();
            }
            catch (SecurityException e) {
                BISLog.e(TAG, e.getMessage());
            }
        }
    }

    public void startLocationGathering() {
        boolean hasCoarseLocation;
        boolean hasFineLocation = ActivityCompat.checkSelfPermission((Context)this.detector.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        boolean bl = hasCoarseLocation = ActivityCompat.checkSelfPermission((Context)this.detector.getContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
        if (!hasFineLocation && !hasCoarseLocation) {
            BISLog.d(this.getClass().getName(), "startLocationGathering() ACCESS_FINE_LOCATION and ACCESS_FINE_LOCATION not granted");
            return;
        }
        if (!this.isCollectingLocationData()) {
            if (this.permissionsTimer != null) {
                this.permissionsTimer.cancel();
            }
            this.permissionsTimer = null;
            this.permissionsTimerTask = null;
            BISLog.d(TAG, "START LOCATION GATHERING (" + this.detector.contextDescription + ")");
            try {
                LocationManager locationManager = (LocationManager)this.detector.getContext().getSystemService("location");
                try {
                    locationManager.requestLocationUpdates("passive", 0L, 0.0f, (LocationListener)this, Looper.getMainLooper());
                }
                catch (Exception e) {
                    BISLog.e(TAG, "requestLocationUpdates failed for passive provider: " + e.getMessage());
                }
                try {
                    locationManager.requestLocationUpdates("gps", 0L, 0.0f, (LocationListener)this, Looper.getMainLooper());
                }
                catch (Exception e) {
                    BISLog.e(TAG, "requestLocationUpdates failed for gps provider: " + e.getMessage());
                }
                try {
                    locationManager.requestLocationUpdates("network", 0L, 0.0f, (LocationListener)this, Looper.getMainLooper());
                }
                catch (Exception e) {
                    BISLog.e(TAG, "requestLocationUpdates failed for network provider: " + e.getMessage());
                }
                this.fetchRegions();
                Integer interval = this.detector.getConfiguration().backgroundDataCollectionMaxLength;
                BISLog.d(TAG, "backgroundDataCollectionMaxLength: " + interval);
                if (this.stickyService && this.stickyIdleTimer != null) {
                    this.stickyIdleTimer.cancel();
                    this.stickyIdleTimer = null;
                    this.stickyIdleTimerTask = null;
                }
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.timer = new Timer();
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            BISCollectionManager.this.stopLocationGathering();
                        }
                        catch (Throwable t) {
                            BISCollectionManager.this.detector.reportCrash(t);
                        }
                    }
                };
                this.timer.schedule(this.timerTask, interval.intValue());
                if (!this.detector.getConfiguration().urlBatchEvent.isEmpty() && !this.detector.getConfiguration().batchEventInterval.isEmpty()) {
                    for (Timer existingTimer : this.intervalTimers) {
                        existingTimer.cancel();
                    }
                    this.intervalTimers.clear();
                    for (Integer intervalValue : this.detector.getConfiguration().batchEventInterval) {
                        Timer intervalTimer = new Timer();
                        TimerTask intervalTimerTask = new TimerTask(){

                            @Override
                            public void run() {
                                BISCollectionManager.this.reportingManager.report();
                            }
                        };
                        intervalTimer.schedule(intervalTimerTask, intervalValue.intValue());
                        this.intervalTimers.add(intervalTimer);
                    }
                }
            }
            catch (SecurityException exception) {
                BISLog.d(this.getClass().getName(), "startLocationGathering() " + exception.getMessage());
                this.permissionsTimer = new Timer();
                this.permissionsTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            BISCollectionManager.this.startLocationGathering();
                        }
                        catch (Throwable t) {
                            BISCollectionManager.this.detector.reportCrash(t);
                        }
                    }
                };
                this.permissionsTimer.schedule(this.permissionsTimerTask, 10000L);
            }
            catch (Throwable t) {
                this.detector.reportCrash(t);
            }
        }
    }

    private void flushGPSEventsAndResetEventCollectionFilterTimer() {
        if (this.eventCollectionFilterTimer != null) {
            this.eventCollectionFilterTimer.cancel();
            this.eventCollectionFilterTimer.purge();
            this.eventCollectionFilterTimer = null;
            this.eventCollectionFilterTimerTask = null;
        }
        this.flushGPSEvents();
    }

    protected void stopLocationGathering() throws SecurityException {
        this.timer = null;
        this.timerTask = null;
        for (Timer existingTimer : this.intervalTimers) {
            existingTimer.cancel();
        }
        this.intervalTimers.clear();
        this.flushGPSEventsAndResetEventCollectionFilterTimer();
        this.reportingManager.report();
        BISLog.d(TAG, "STOP LOCATION GATHERING (" + this.detector.contextDescription + ")");
        LocationManager locationManager = (LocationManager)this.detector.getContext().getSystemService("location");
        locationManager.removeUpdates((LocationListener)this);
        locationManager.requestLocationUpdates("passive", 0L, 0.0f, (LocationListener)this, Looper.getMainLooper());
        if (this.stickyService) {
            Integer interval = this.detector.getConfiguration().locationMonitoringInterval;
            this.stickyIdleTimer = new Timer();
            this.stickyIdleTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        BISCollectionManager.this.startLocationGathering();
                    }
                    catch (Throwable t) {
                        BISCollectionManager.this.detector.reportCrash(t);
                    }
                }
            };
            this.stickyIdleTimer.schedule(this.stickyIdleTimerTask, interval.intValue());
        }
    }

    private boolean isCollectingLocationData() {
        return this.timer != null;
    }

    private void setupGeofencingClient() {
        try {
            this.mGeofencingClient = LocationServices.getGeofencingClient((Context)this.detector.getContext());
        }
        catch (Throwable t) {
            BISLog.e(this.getClass().getName(), "setupGeofencingClient() " + t.getMessage());
        }
    }

    private void saveEvent(BISCollectionEvent event) {
        BISLog.d(TAG, "Saved " + event.getEventType() + " event. (" + this.detector.contextDescription + ")");
        this.reportingManager.addEvent(event);
        boolean firstFetch = this.lastEvent == null;
        this.lastEvent = event;
        if (firstFetch) {
            this.fetchRegions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGPSEvent(BISCollectionEvent event) {
        Integer interval = this.detector.getConfiguration().eventCollectionFilterLength;
        if (interval == 0) {
            this.saveEvent(event);
            return;
        }
        List<BISCollectionEvent> list = this.gpsBuffer;
        synchronized (list) {
            this.gpsBuffer.add(event);
        }
        if (this.eventCollectionFilterTimer == null) {
            this.eventCollectionFilterTimer = new Timer();
            this.eventCollectionFilterTimerTask = new TimerTask(){

                @Override
                public void run() {
                    BISCollectionManager.this.flushGPSEventsAndResetEventCollectionFilterTimer();
                }
            };
            this.eventCollectionFilterTimer.schedule(this.eventCollectionFilterTimerTask, interval.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushGPSEvents() {
        BISCollectionEvent bestEvent = null;
        List<BISCollectionEvent> list = this.gpsBuffer;
        synchronized (list) {
            for (BISCollectionEvent event : this.gpsBuffer) {
                if (bestEvent == null) {
                    bestEvent = event;
                    continue;
                }
                if (bestEvent.location == null || event.location == null) continue;
                float bestEventAccuracy = bestEvent.location.getAccuracy();
                float eventAccuracy = event.location.getAccuracy();
                if (!(eventAccuracy < bestEventAccuracy)) continue;
                bestEvent = event;
            }
            this.gpsBuffer.clear();
        }
        if (bestEvent != null) {
            this.saveEvent(bestEvent);
        }
    }

    private void fetchRegions() {
        if (ActivityCompat.checkSelfPermission((Context)this.detector.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            BISLog.d(this.getClass().getName(), "fetchRegions() ACCESS_FINE_LOCATION not granted");
            return;
        }
        if (this.lastLocation == null) {
            BISLog.d(this.getClass().getName(), "fetchRegions() needs a last location");
            return;
        }
        try {
            this.getGeofences();
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
    }

    private void getGeofences() {
        this.getGeofences(this.detector.getConfiguration().urlGeofence);
    }

    private void getGeofences(final List<String> apiUrls) {
        BISLog.d(TAG, "COLLECTING GEO-FENCE CONFIGURATION");
        if (this.getLastKnownLocation() == null || apiUrls == null || apiUrls.isEmpty()) {
            return;
        }
        final String apiUrl = apiUrls.get(0);
        final BISCollectionManager self = this;
        BISNetworking.getGeofences(this.detector, apiUrl, this.getLastKnownLocation(), new BISNetworkingThreadListener<String>(){

            @Override
            public void onSuccess(String responseString) {
                try {
                    if (responseString == null) {
                        throw new JSONException("response is null");
                    }
                    JSONObject response = new JSONObject(responseString);
                    JSONObject data = response.getJSONObject("data");
                    JSONArray array = data.getJSONArray("geofence");
                    ArrayList<Geofence> geofences = new ArrayList<Geofence>();
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject geofenceJson = array.getJSONObject(i);
                        double latitude = geofenceJson.getDouble("latitude");
                        double longitude = geofenceJson.getDouble("longitude");
                        float radius = (float)geofenceJson.getDouble("radius");
                        Geofence geofence = new Geofence.Builder().setRequestId(latitude + "+" + longitude + "+" + radius).setCircularRegion(latitude, longitude, radius).setExpirationDuration(-1L).setTransitionTypes(7).setLoiteringDelay(30000).build();
                        geofences.add(geofence);
                    }
                    if (self.mGeofencingClient != null) {
                        self.mGeofencingClient.removeGeofences(BISCollectionManager.this.getGeofencePendingIntent());
                        if (geofences != null) {
                            BISCollectionManager.this.mGeofenceList.clear();
                            BISCollectionManager.this.mGeofenceList.addAll(geofences);
                        }
                        if (!BISCollectionManager.this.mGeofenceList.isEmpty() && ActivityCompat.checkSelfPermission((Context)self.detector.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
                            self.mGeofencingClient.addGeofences(BISCollectionManager.this.getGeofencingRequest(), BISCollectionManager.this.getGeofencePendingIntent());
                        }
                    }
                }
                catch (Exception e) {
                    ArrayList<String> newUrls = new ArrayList<String>();
                    for (String newUrl : apiUrls) {
                        if (newUrl.equals(apiUrl)) continue;
                        newUrls.add(newUrl);
                    }
                    BISCollectionManager.this.getGeofences(newUrls);
                }
            }

            @Override
            public void onError(Throwable t) {
                ArrayList<String> newUrls = new ArrayList<String>();
                for (String newUrl : apiUrls) {
                    if (newUrl.equals(apiUrl)) continue;
                    newUrls.add(newUrl);
                }
                BISCollectionManager.this.getGeofences(newUrls);
            }
        });
    }

    private GeofencingRequest getGeofencingRequest() {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences(this.mGeofenceList);
        return builder.build();
    }

    private PendingIntent getGeofencePendingIntent() {
        if (this.mGeofencePendingIntent != null) {
            return this.mGeofencePendingIntent;
        }
        Intent intent = new Intent(this.detector.getContext(), BISGeofenceTransitionsIntentService.class);
        this.mGeofencePendingIntent = PendingIntent.getService((Context)this.detector.getContext(), (int)0, (Intent)intent, (int)0x8000000);
        return this.mGeofencePendingIntent;
    }

    private void startBeaconManager() {
        boolean hasBluetoothAdmin;
        if (!this.detector.getConfiguration().isModelSupportedForBluetoothUse()) {
            return;
        }
        boolean hasBluetooth = ActivityCompat.checkSelfPermission((Context)this.detector.getContext(), (String)"android.permission.BLUETOOTH") == 0;
        boolean bl = hasBluetoothAdmin = ActivityCompat.checkSelfPermission((Context)this.detector.getContext(), (String)"android.permission.BLUETOOTH_ADMIN") == 0;
        if (!hasBluetooth) {
            BISLog.d(this.getClass().getName(), "startBeaconManager() BLUETOOTH not granted");
            return;
        }
        if (!hasBluetoothAdmin) {
            BISLog.d(this.getClass().getName(), "startBeaconManager() BLUETOOTH_ADMIN not granted");
            return;
        }
        try {
            String iBeaconLayout = "m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24";
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(iBeaconLayout));
            String altBeaconLayout = "m:2-3=beac,i:4-19,i:20-21,i:22-23,p:24-24,d:25-25";
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(altBeaconLayout));
            String eddystoneUIDBeaconLayout = "s:0-1=feaa,m:2-2=00,p:3-3:-41,i:4-13,i:14-19";
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(eddystoneUIDBeaconLayout));
            String eddystoneURLBeaconLayout = "s:0-1=feaa,m:2-2=10,p:3-3:-41,i:4-20v";
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(eddystoneURLBeaconLayout));
            try {
                this.setBeaconScanPeriods();
            }
            catch (ReceiverCallNotAllowedException e) {
                BISLog.e(TAG, e.getMessage());
            }
            if (Build.VERSION.SDK_INT >= 26) {
                BluetoothAdapter bluetoothAdapter;
                ScanSettings settings = new ScanSettings.Builder().setScanMode(0).build();
                BluetoothManager bluetoothManager = (BluetoothManager)this.detector.getContext().getSystemService("bluetooth");
                if (bluetoothManager != null && (bluetoothAdapter = bluetoothManager.getAdapter()) != null && bluetoothAdapter.isEnabled()) {
                    Intent intent = new Intent(this.detector.getContext(), BISBeaconReceiver.class);
                    intent.putExtra("o-scan", true);
                    PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.detector.getContext(), (int)0, (Intent)intent, (int)0x8000000);
                    BluetoothLeScanner scanner = bluetoothAdapter.getBluetoothLeScanner();
                    if (scanner != null) {
                        try {
                            scanner.startScan(null, settings, pendingIntent);
                        }
                        catch (Exception permissionException) {
                            BISLog.e(TAG, "RuntimeException likely. BLUETOOTH_PRIVILEGED not granted? " + permissionException.getMessage());
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
    }

    private void setBeaconScanPeriods() {
        if (this.beaconManager == null) {
            return;
        }
        try {
            this.beaconManager.setForegroundScanPeriod((long)this.detector.getConfiguration().foregroundBluetoothScanPeriod.intValue());
            this.beaconManager.setForegroundBetweenScanPeriod((long)this.detector.getConfiguration().foregroundBluetoothBetweenScanPeriod.intValue());
            this.beaconManager.setBackgroundScanPeriod((long)this.detector.getConfiguration().backgroundBluetoothScanPeriod.intValue());
            this.beaconManager.setBackgroundBetweenScanPeriod((long)this.detector.getConfiguration().backgroundBluetoothBetweenScanPeriod.intValue());
            this.doBindBeaconManager();
            if (this.beaconManager.isBound((BeaconConsumer)this)) {
                this.beaconManager.updateScanPeriods();
            }
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
    }

    public void onBeaconServiceConnect() {
        try {
            this.beaconManager.setRangeNotifier(new RangeNotifier(){

                public void didRangeBeaconsInRegion(Collection<Beacon> collection, Region region) {
                    try {
                        Long beaconLastSeenTimestamp;
                        Long currentTimestamp = System.currentTimeMillis();
                        for (Beacon beacon : collection) {
                            beaconLastSeenTimestamp = (Long)beaconTimestampMap.get(beacon);
                            if (beaconLastSeenTimestamp == null) {
                                BISLog.d(BISCollectionManager.TAG, "ENTERED BEACON " + BISCollectionManager.this.uniqueIdentifierForBeacon(beacon));
                                BISCollectionManager.this.handleBeaconEnter(beacon);
                                beaconRssiMap.put(beacon, new BISDetectorRSSICollector());
                            }
                            BISDetectorRSSICollector rssiCollector = (BISDetectorRSSICollector)beaconRssiMap.get(beacon);
                            rssiCollector.add(beacon.getRssi());
                            beaconRssiMap.put(beacon, rssiCollector);
                            beaconTimestampMap.put(beacon, currentTimestamp);
                        }
                        for (Beacon beacon : beaconTimestampMap.keySet()) {
                            beaconLastSeenTimestamp = (Long)beaconTimestampMap.get(beacon);
                            Long diff = currentTimestamp - beaconLastSeenTimestamp;
                            if (diff <= BEACON_EXIT_THRESHOLD) continue;
                            BISLog.d(BISCollectionManager.TAG, "EXITED BEACON " + BISCollectionManager.this.uniqueIdentifierForBeacon(beacon));
                            BISCollectionManager.this.handleBeaconExit(beacon);
                            beaconTimestampMap.remove(beacon);
                        }
                    }
                    catch (Throwable t) {
                        BISCollectionManager.this.detector.reportCrash(t);
                    }
                }
            });
            this.beaconManager.startRangingBeaconsInRegion(new Region("ALL_BEACONS", null, null, null));
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
    }

    public Context getApplicationContext() {
        return this.detector.getContext();
    }

    public void unbindService(ServiceConnection serviceConnection) {
        try {
            this.detector.getContext().unbindService(serviceConnection);
        }
        catch (IllegalArgumentException e) {
            BISLog.e(TAG, e.getMessage());
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
    }

    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        try {
            return this.detector.getContext().bindService(intent, serviceConnection, i);
        }
        catch (ReceiverCallNotAllowedException e) {
            BISLog.e(TAG, e.getMessage());
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
        return false;
    }

    private void doBindBeaconManager() {
        try {
            if (this.beaconManager != null && !this.beaconManager.isBound((BeaconConsumer)this)) {
                this.beaconManager.bind((BeaconConsumer)this);
            }
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
    }

    private void undoBindBeaconManager() {
        try {
            if (this.beaconManager != null && this.beaconManager.isBound((BeaconConsumer)this)) {
                this.beaconManager.unbind((BeaconConsumer)this);
            }
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
    }

    public void startRanging() {
        try {
            this.stopRanging();
            this.doBindBeaconManager();
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
    }

    public void stopRanging() {
        try {
            Collection regions = this.beaconManager.getRangedRegions();
            for (Region region : regions) {
                this.beaconManager.stopRangingBeaconsInRegion(region);
            }
            this.undoBindBeaconManager();
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
    }

    private void handleBeaconEnter(Beacon beacon) {
        BISCollectionEvent event = new BISCollectionEvent(this.detector.getContext(), BISCollectionEvent.BISCollectionEventType.BeaconInteraction, this.detector.applicationState, BISCollectionEvent.BISCollectionEventDirection.Enter, beacon);
        event.location = this.lastLocation;
        this.triggerEvent(event);
    }

    private void handleBeaconExit(Beacon beacon) {
        BISCollectionEvent event = new BISCollectionEvent(this.detector.getContext(), BISCollectionEvent.BISCollectionEventType.BeaconInteraction, this.detector.applicationState, BISCollectionEvent.BISCollectionEventDirection.Exit, beacon, beaconRssiMap.get(beacon));
        event.location = this.lastLocation;
        this.triggerEvent(event);
    }

    private static String beaconIdentifierToString(Identifier i) {
        try {
            if (i == null) {
                return null;
            }
            String s = i.toString();
            if (s == null) {
                return null;
            }
            if (s.length() >= 2 && s.substring(0, 2).equals("0x")) {
                s = s.substring(2);
            }
            return s;
        }
        catch (Throwable t) {
            BISLog.e(TAG, t.getMessage());
            return null;
        }
    }

    private String[] idsForBeacon(Beacon beacon) {
        if (beacon == null) {
            return new String[]{"", "", ""};
        }
        Identifier id1 = null;
        Identifier id2 = null;
        Identifier id3 = null;
        try {
            id1 = beacon.getIdentifiers().size() > 0 ? beacon.getId1() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            id2 = beacon.getIdentifiers().size() > 1 ? beacon.getId2() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            id3 = beacon.getIdentifiers().size() > 2 ? beacon.getId3() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String ID1 = id1 != null ? BISCollectionManager.beaconIdentifierToString(id1) : "";
        String ID2 = id2 != null ? BISCollectionManager.beaconIdentifierToString(id2) : "";
        String ID3 = id3 != null ? BISCollectionManager.beaconIdentifierToString(id3) : "";
        return new String[]{ID1, ID2, ID3};
    }

    private String uniqueIdentifierForBeacon(Beacon beacon) {
        if (beacon == null) {
            return "";
        }
        String s = null;
        try {
            String[] strings = this.idsForBeacon(beacon);
            String id1 = strings[0];
            String id2 = strings[1];
            String id3 = strings[2];
            String uniqueId = id1 + "_" + id2 + "_" + id3;
            s = id1 + ":" + uniqueId.hashCode();
        }
        catch (Throwable t) {
            this.detector.reportCrash(t);
        }
        return s;
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.startLocationGathering();
    }

    public void onActivityPaused(Activity activity) {
        this.reportingManager.report();
    }

    public void onActivityStopped(Activity activity) {
        this.reportingManager.report();
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

