/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISException;
import com.beaconsinspace.android.beacon.detector.BISNetworking;
import com.beaconsinspace.android.beacon.detector.BISNetworkingThread;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

class BISNetworkingGetThread
extends BISNetworkingThread<String> {
    private static final String TAG = "BIS_NETWORK_REQUEST";
    public static final int STATUS_SUCCESS = 200;
    private final BISDetector detector;
    private final String uri;

    public BISNetworkingGetThread(BISDetector detector, String uri) {
        this.detector = detector;
        this.uri = uri;
    }

    private String readStream(InputStream stream) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder fullString = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            fullString.append(line);
        }
        return fullString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream inputStream = null;
        try {
            String authorizationHeader = BISNetworking.getAuthorizationHeader(this.detector);
            URL url = new URL(this.uri);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Authorization", authorizationHeader);
            connection.setConnectTimeout(30000);
            connection.connect();
            int response = connection.getResponseCode();
            if (response == 200) {
                inputStream = new BufferedInputStream(connection.getInputStream());
                String result = this.readStream(inputStream);
                if (this.listener != null) {
                    this.listener.onSuccess(result);
                }
            } else {
                if (this.listener != null) {
                    this.listener.onError(new BISException("Not found"));
                }
                Log.i((String)TAG, (String)("STATUS_CODE is " + response));
            }
        }
        catch (Throwable t) {
            if (this.listener != null) {
                this.listener.onError(t);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Throwable t) {
                this.detector.reportCrash(t);
            }
        }
    }
}

