/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

class StorageProperties {
    private static final String TAG = StorageProperties.class.getName();
    private static final int MEGABYTE = 0x100000;
    private static final String MAX_INTERNAL_STORAGE_MB = "maxInternalStorageMB";
    private static final String MAX_EXTERNAL_STORAGE_MB = "maxExternalStorageMB";
    private static final String IS_EXTERNAL_STORAGE_EMULATED = "isExternalStorageEmulated";

    StorageProperties() {
    }

    public static JSONObject getProperties() throws JSONException {
        JSONObject props = new JSONObject();
        props.put(MAX_INTERNAL_STORAGE_MB, StorageProperties.getStorageTotalSizeMB(Environment.getRootDirectory()));
        props.put(MAX_EXTERNAL_STORAGE_MB, StorageProperties.getStorageTotalSizeMB(Environment.getExternalStorageDirectory()));
        if (Build.VERSION.SDK_INT >= 11) {
            props.put(IS_EXTERNAL_STORAGE_EMULATED, Environment.isExternalStorageEmulated());
        }
        return props;
    }

    private static long getStorageTotalSizeMB(File path) {
        long totalBytes = 0L;
        try {
            StatFs stat = new StatFs(path.getPath());
            totalBytes = Build.VERSION.SDK_INT >= 18 ? stat.getBlockSizeLong() * stat.getBlockCountLong() : (long)stat.getBlockSize() * (long)stat.getBlockCount();
        }
        catch (IllegalArgumentException ex) {
            Log.d((String)TAG, (String)ex.toString());
        }
        return totalBytes / 0x100000L;
    }
}

