/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISLog;
import java.util.Timer;
import java.util.TimerTask;

@TargetApi(value=26)
public class BISJobService
extends JobService {
    private Timer timer;
    private TimerTask timerTask;
    private static final String TAG = "BISJobService";

    public boolean onStartJob(final JobParameters jobParameters) {
        try {
            final BISDetector detector = new BISDetector(this.getApplicationContext());
            detector.bootstrap();
            Integer interval = detector.getConfiguration().backgroundDataCollectionMaxLength;
            BISCollectionManager collectionManager = detector.getCollectionManager();
            if (collectionManager != null) {
                collectionManager.startLocationGathering();
                this.timer = new Timer();
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            BISJobService.this.jobFinished(jobParameters, false);
                        }
                        catch (Throwable t) {
                            detector.reportCrash(t);
                        }
                    }
                };
                this.timer.schedule(this.timerTask, interval.intValue());
                return true;
            }
        }
        catch (Throwable t) {
            BISLog.e(TAG, t.getMessage());
        }
        return false;
    }

    public boolean onStopJob(JobParameters jobParameters) {
        BISDetector detector = null;
        try {
            detector = new BISDetector(this.getApplicationContext());
            detector.bootstrap();
            BISCollectionManager collectionManager = detector.getCollectionManager();
            if (collectionManager != null) {
                collectionManager.stopLocationGathering();
            }
        }
        catch (Throwable t) {
            if (detector != null) {
                detector.reportCrash(t);
            }
            BISLog.e(TAG, t.getMessage());
        }
        return false;
    }
}

