/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISLog;

public class BISDetectorServicesListener
extends BroadcastReceiver {
    private static final String TAG = "BIS_LISTENER";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        BISLog.i(TAG, "Intent action: " + action);
        if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
            BISDetector detector = new BISDetector(context);
            detector.bootstrap();
            BISCollectionManager collectionManager = detector.getCollectionManager();
            if (collectionManager != null) {
                switch (state) {
                    case 10: {
                        collectionManager.stopRanging();
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 12: {
                        collectionManager.startRanging();
                        break;
                    }
                    case 11: {
                        break;
                    }
                }
            }
        }
    }
}

