/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISConfiguration;
import com.beaconsinspace.android.beacon.detector.BISDeviceAtlas;
import com.beaconsinspace.android.beacon.detector.BISDeviceUUID;
import com.beaconsinspace.android.beacon.detector.BISJobService;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISLogDelegate;
import com.beaconsinspace.android.beacon.detector.BISNetworkingCrashTask;
import com.beaconsinspace.android.beacon.detector.BISPersistentStorage;
import java.util.UUID;

public class BISDetector
extends Service
implements Application.ActivityLifecycleCallbacks {
    public static final String SDK_VERSION = "2.0.4";
    private static final String TAG = "BIS_API";
    private String apiKey = "";
    private String adid = "";
    private UUID uuid;
    static BISLogDelegate logDelegate;
    private BISCollectionManager collectionManager;
    private BISConfiguration configuration;
    private Thread primaryProcessThread;
    private Context context;
    private BISPersistentStorage persistentStorage;
    public ApplicationState applicationState = ApplicationState.BACKGROUND;

    public BISDetector() {
    }

    public BISDetector(@NonNull Context context) {
        this.context = context;
        if (context != null) {
            this.persistentStorage = new BISPersistentStorage(context);
            this.apiKey = this.persistentStorage.getString("BIS_API_KEY");
            this.setupCallbacks();
        }
    }

    public BISDetector(@NonNull Context context, @NonNull String apiKey) {
        this.context = context;
        if (context != null) {
            this.persistentStorage = new BISPersistentStorage(context);
            this.apiKey = apiKey;
            this.persistentStorage.storeString("BIS_API_KEY", apiKey);
            this.setupCallbacks();
        }
    }

    private void setupCallbacks() {
        if (this.context instanceof Application) {
            Application application = (Application)this.context;
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.applicationState = ApplicationState.INACTIVE;
    }

    public void onActivityStarted(Activity activity) {
        this.applicationState = ApplicationState.ACTIVE;
    }

    public void onActivityResumed(Activity activity) {
        this.applicationState = ApplicationState.ACTIVE;
    }

    public void onActivityPaused(Activity activity) {
        this.applicationState = ApplicationState.BACKGROUND;
    }

    public void onActivityStopped(Activity activity) {
        this.applicationState = ApplicationState.BACKGROUND;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public static void configure(String key, Context ctx) {
        BISDetector.configure(key, ctx, null);
    }

    private static void configure(String key, Context ctx, BISLogDelegate logDelegate) {
        Log.d((String)TAG, (String)"Configuring BISDetector SDK 2.0.4");
        BISDetector.logDelegate = logDelegate;
        BISDetector detector = new BISDetector(ctx, key);
        BISDetector.scheduleJob(detector);
        if (Build.VERSION.SDK_INT >= 26) {
            detector.foregroundService();
        } else {
            ctx.sendBroadcast(new Intent("BootstrapBeaconsInSpace"));
        }
    }

    private void foregroundService() {
        if (this.primaryProcessThread == null) {
            this.primaryProcessThread = new Thread(){

                @Override
                public void run() {
                    try {
                        BISDetector.this.bootstrap();
                    }
                    catch (Throwable e) {
                        BISLog.e(BISDetector.TAG, e.getMessage());
                    }
                }
            };
            this.primaryProcessThread.start();
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.context = this.getApplicationContext();
        this.persistentStorage = new BISPersistentStorage(this.context);
        this.apiKey = this.persistentStorage.getString("BIS_API_KEY");
        if (this.primaryProcessThread == null) {
            this.primaryProcessThread = new Thread(){

                @Override
                public void run() {
                    try {
                        BISDetector.this.bootstrap();
                    }
                    catch (Throwable t) {
                        BISDetector.this.reportCrash(t);
                    }
                }
            };
            this.primaryProcessThread.start();
        }
        return 1;
    }

    private static void scheduleJob(BISDetector detector) {
        if (Build.VERSION.SDK_INT >= 26) {
            BISLog.d(TAG, "Scheduling job");
            BISConfiguration configuration = new BISConfiguration(detector);
            int jobId = 1337;
            ComponentName mServiceComponent = new ComponentName(detector.getContext(), BISJobService.class);
            JobInfo.Builder builder = new JobInfo.Builder(jobId, mServiceComponent);
            builder.setPeriodic((long)configuration.locationMonitoringInterval.intValue());
            builder.setRequiredNetworkType(1);
            JobScheduler tm = (JobScheduler)detector.getContext().getSystemService("jobscheduler");
            tm.cancel(jobId);
            tm.schedule(builder.build());
        }
    }

    public void bootstrap() {
        if (this.context == null) {
            Log.d((String)TAG, (String)"Context must be set before bootstrap.");
            return;
        }
        if (this.persistentStorage == null) {
            Log.d((String)TAG, (String)"Persistent storage must be set before bootstrap.");
            return;
        }
        if (this.apiKey == null) {
            Log.d((String)TAG, (String)"API KEY must be set before bootstrap.");
            return;
        }
        if (!BISDetector.isSafeToBootstrap()) {
            Log.d((String)TAG, (String)"This device is not supported. BeaconsInSpace Detector shutting down");
            return;
        }
        try {
            this.configuration = new BISConfiguration(this);
            BISDeviceUUID deviceUUID = new BISDeviceUUID(this.context);
            this.uuid = deviceUUID.getDeviceUuid();
            this.getUserADID();
            if (!this.persistentStorage.isDeviceMetaDataCollected()) {
                this.bootDeviceAtlas();
            }
            this.collectionManager = new BISCollectionManager(this);
        }
        catch (Throwable t) {
            this.reportCrash(t);
        }
    }

    public IBinder onBind(Intent arg0) {
        return null;
    }

    public void onDestroy() {
        this.sendBroadcast(new Intent("BootstrapBeaconsInSpace"));
        super.onDestroy();
    }

    private static boolean isSafeToBootstrap() {
        if (Build.VERSION.SDK_INT < 18) {
            Log.e((String)TAG, (String)("BeaconsInSpace Detector Library does not run on Android: " + Build.VERSION.SDK_INT));
            return false;
        }
        return true;
    }

    static void performInitialSetup() {
        Log.i((String)TAG, (String)"BeaconsInSpace has bootstrapped successfully");
    }

    private void getUserADID() {
        if (this.context == null) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        thread.start();
    }

    private void onUserADIDReceiveSuccess() {
        BISDetector.performInitialSetup();
    }

    private void onUserADIDReceiveFail() {
        BISDetector.performInitialSetup();
    }

    private void bootDeviceAtlas() {
        Intent transparentActivityIntent = new Intent(this.context, BISDeviceAtlas.class);
        transparentActivityIntent.setFlags(0x10000000);
        this.context.startActivity(transparentActivityIntent);
    }

    public BISCollectionManager getCollectionManager() {
        return this.collectionManager;
    }

    public BISConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getAPIKey() {
        return this.apiKey;
    }

    public Context getContext() {
        return this.context;
    }

    public String getADID() {
        return this.adid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public BISPersistentStorage getPersistentStorage() {
        return this.persistentStorage;
    }

    public void reportCrash(Throwable throwable) {
        BISLog.e("BIS_CRASH", throwable.getClass().getName() + ": " + throwable.getMessage());
        try {
            BISConfiguration configuration = this.getConfiguration();
            BISNetworkingCrashTask task = configuration == null ? new BISNetworkingCrashTask("https://sentry.io/api/284645/store/", "3d915666beba410c89fe6cb9a3034539", "512bdf97ca284100b0eed543bca78654") : new BISNetworkingCrashTask(configuration.sentryUrl, configuration.sentryKey, configuration.sentrySecret);
            task.execute(new Throwable[]{throwable});
            task.get();
        }
        catch (Throwable crashThrowable) {
            BISLog.e("BIS_CRASH_REPORTING", throwable.getClass().getName() + ": " + throwable.getMessage());
        }
    }

    static /* synthetic */ Context access$000(BISDetector x0) {
        return x0.context;
    }

    static /* synthetic */ String access$202(BISDetector x0, String x1) {
        x0.adid = x1;
        return x0.adid;
    }

    static /* synthetic */ String access$200(BISDetector x0) {
        return x0.adid;
    }

    static enum ApplicationState {
        ACTIVE,
        INACTIVE,
        BACKGROUND;

    }
}

