package com.beaconsinspace.android.beacon.detector;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;

import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by kyleshank on 10/12/17.
 */

@TargetApi(26)
public class BISJobService extends JobService {
    private Timer timer;
    private TimerTask timerTask;

    private static final String TAG = "BISJobService";

    @Override
    public boolean onStartJob(final JobParameters jobParameters) {
        try {
            final BISDetector detector = new BISDetector(getApplicationContext());
            detector.bootstrap();

            Integer interval = detector.getConfiguration().backgroundDataCollectionMaxLength;

            BISCollectionManager collectionManager = detector.getCollectionManager();
            if (collectionManager != null) {
                collectionManager.startLocationGathering();
                timer = new Timer();
                timerTask = new TimerTask() {
                    public void run() {
                        try {
                            jobFinished(jobParameters, false);
                        } catch (Throwable t) {
                            detector.reportCrash(t);
                        }
                    }
                };
                timer.schedule(timerTask, (long) interval);
                return true;
            }
        } catch (Throwable t) {
            BISLog.e(TAG,t.getMessage());
        }

        return false;
    }

    @Override
    public boolean onStopJob(JobParameters jobParameters) {
        BISDetector detector = null;
        try {
            detector = new BISDetector(getApplicationContext());
            detector.bootstrap();

            BISCollectionManager collectionManager = detector.getCollectionManager();
            if (collectionManager != null) {
                collectionManager.stopLocationGathering();
            }
        } catch (Throwable t) {
            if ( detector != null ) {
                detector.reportCrash(t);
            } else {
                BISLog.e(TAG,t.getMessage());
            }
        }
        return false;
    }
}
