package com.beaconsinspace.android.beacon.detector;

import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconParser;

import java.util.ArrayList;

/**
 * Created by kyleshank on 10/11/17.
 */

public class BISBeaconReceiver extends BroadcastReceiver {
    private static String TAG = "BISBeaconReceiver";


    @Override
    public void onReceive(Context context, Intent intent) {
        final BISDetector bisDetector;
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                int bleCallbackType = intent.getIntExtra(BluetoothLeScanner.EXTRA_CALLBACK_TYPE, -1);
                if (bleCallbackType != -1) {
                    BISLog.d(TAG, "Passive background scan callback type: " + bleCallbackType);
                    final ArrayList<ScanResult> scanResults = intent.getParcelableArrayListExtra(
                            BluetoothLeScanner.EXTRA_LIST_SCAN_RESULT);

                    bisDetector = new BISDetector(context);
                    bisDetector.bootstrap();

                    final BISCollectionManager collectionManager = bisDetector.getCollectionManager();

                    if (collectionManager != null) {
                        final PendingResult result = goAsync();
                        final Context theContext = context;
                        Thread thread = new Thread() {
                            public void run() {
                                try {
                                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                        for (ScanResult scanResult : scanResults) {
                                            BeaconParser parser = new BeaconParser();
                                            Beacon beacon = parser.fromScanData(
                                                    scanResult.getScanRecord().getBytes(),
                                                    scanResult.getRssi(), scanResult.getDevice());
                                            BISCollectionEvent event = new BISCollectionEvent(
                                                    theContext,
                                                    BISCollectionEvent.BISCollectionEventType.BeaconInteraction,
                                                    bisDetector.applicationState,
                                                    BISCollectionEvent.BISCollectionEventDirection.Enter,
                                                    beacon);
                                            event.location = collectionManager.getLastKnownLocation();
                                            collectionManager.triggerEvent(event);
                                        }

                                        collectionManager.startLocationGathering();
                                    }
                                    result.finish();
                                } catch (Throwable t) {
                                    if (bisDetector != null) {
                                        bisDetector.reportCrash(t);
                                    }
                                }
                            }
                        };
                        thread.start();
                    }
                }
            }
        } catch (Throwable t) {
            BISLog.e(TAG,t.getMessage());
        }
    }
}
