/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.content.Context;
import android.os.Build;
import com.beaconsinspace.android.beacon.detector.deviceatlas.Camera;
import com.beaconsinspace.android.beacon.detector.deviceatlas.CameraV1;
import com.beaconsinspace.android.beacon.detector.deviceatlas.CameraV2;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CameraProperties {
    private static final String TAG = CameraProperties.class.getName();
    protected static final String FACING_FRONT = "front";
    protected static final String FACING_BACK = "back";
    protected static final String FACING_EXTERNAL = "external";
    protected static final String WIDTH_PIXELS = "widthPixels";
    protected static final String HEIGHT_PIXELS = "heightPixels";
    protected static final String MEGA_PIXELS = "megaPixels";
    protected static final String FACING = "facing";
    protected static final String HAS_FLASH = "hasFlash";

    CameraProperties() {
    }

    public static JSONArray getProperties(Context context) throws JSONException {
        List<Object> cameras = new ArrayList();
        if (Build.VERSION.SDK_INT >= 21) {
            cameras = CameraV2.getCameras(context);
        } else if (Build.VERSION.SDK_INT >= 9) {
            cameras = CameraV1.getCameras();
        }
        JSONArray toReturn = new JSONArray();
        for (Camera camera : cameras) {
            JSONObject props = new JSONObject();
            props.put(WIDTH_PIXELS, camera.widthPixels);
            props.put(HEIGHT_PIXELS, camera.heightPixels);
            props.put(MEGA_PIXELS, (Object)camera.megaPixels);
            props.put(FACING, (Object)camera.facing);
            props.put(HAS_FLASH, camera.hasFlash);
            toReturn.put((Object)props);
        }
        return toReturn;
    }
}

