/*
 * Copyright (c) Afilias Technologies Ltd 2017. All rights reserved.
 */


package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.app.Activity;
import android.opengl.GLSurfaceView;
import android.view.ViewGroup;

/**
 * @author Afilias Technologies Ltd
 */
class GpuLoader {

    public void load(final Activity activityContext, final DataCollectorTask.AsyncResponse callback) {

        activityContext.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                final GLSurfaceView glView = new GLSurfaceView(activityContext);

                glView.setZOrderOnTop(true); // on top so is rendered correctly
                GpuRenderer renderer = new GpuRenderer(activityContext, glView, callback);

                glView.setRenderer(renderer);

                // add opengl view to current active view
                ViewGroup layout = (ViewGroup) activityContext.findViewById(android.R.id.content); // needs to be layout of current active view
                layout.addView(glView);
            }
        });
    }

}
