package com.beaconsinspace.android.beacon.detector;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by kyleshank on 7/24/17.
 */

public class BISReportingManager {
    private int bufferHead = 0;
    private int bufferSize = 1000;
    private BISCollectionEvent[] buffer;
    private Context context;
    private boolean isBatchReporting = false;

    public BISReportingManager(Context context){
        this.context = context;
        buffer = new BISCollectionEvent[bufferSize];
    }

    public void addEvent(BISCollectionEvent event){
        synchronized (buffer) {
            buffer[bufferHead] = event;

            bufferHead = (bufferHead + 1) % bufferSize;
        }
        if (!BISConfiguration.getCurrentConfiguration().urlSingleEvent.isEmpty()) {
            reportSingle(BISConfiguration.getCurrentConfiguration().urlSingleEvent);
        }
    }

    public void report(){
        BISLog.d(this.getClass().getName(), "report()");
        if (!BISConfiguration.getCurrentConfiguration().urlSingleEvent.isEmpty()) {
            reportSingle(BISConfiguration.getCurrentConfiguration().urlSingleEvent);
        }else if (!BISConfiguration.getCurrentConfiguration().urlBatchEvent.isEmpty()) {
            reportBatch(BISConfiguration.getCurrentConfiguration().urlBatchEvent);
        }
    }

    private void reportSingle(List<String> urls){
        for(int i = 0; i < buffer.length; i++){
            int tempBufferHead = (bufferHead + i) % bufferSize;
            BISCollectionEvent event = buffer[tempBufferHead];
            if (event != null){
                reportSingleEvent(urls, event);
            }
        }
    }

    private void reportSingleEvent(List<String> urls, BISCollectionEvent event){
        if (!urls.isEmpty()){
            String apiUrl = urls.get(0);
            if (apiUrl != null){
                try {
                    BISNetworking.getSharedManger().reportSingleEvent(
                            apiUrl, event, BISConfiguration.getCurrentConfiguration().bisData);
                    removeEvent(event);
                } catch (Exception e) {
                    BISLog.e(this.getClass().getName(), "reportSingleEvent(" + e.getMessage() + ")");
                    List<String> newUrls = new ArrayList<String>();
                    for (String newUrl : urls ){
                        if (!newUrl.equals(apiUrl)){
                            newUrls.add(newUrl);
                        }
                    }
                    reportSingleEvent(newUrls, event);
                }
            }
        }
    }

    private void reportBatch(List<String> urls){
        if (!isBatchReporting){
            synchronized (buffer){
                if (buffer.length > 0){
                    isBatchReporting = true;
                    reportBatchEvent(urls, buffer);
                }
            }
        }
    }

    private void reportBatchEvent(List<String> urls, BISCollectionEvent[] events){
        if (!urls.isEmpty()){
            String apiUrl = urls.get(0);
            if (apiUrl != null){
                try {
                    List<BISCollectionEvent> eventsList = new ArrayList<BISCollectionEvent>();
                    for (BISCollectionEvent event : events){
                        if(event != null){
                            eventsList.add(event);
                        }
                    }
                    BISNetworking.getSharedManger().reportBatchEvent(apiUrl, eventsList, BISConfiguration.getCurrentConfiguration().bisData);
                    for (BISCollectionEvent event : eventsList) {
                        removeEvent(event);
                    }
                    isBatchReporting = false;
                } catch (Exception e) {
                    BISLog.e(this.getClass().getName(), "reportBatchEvent(" + e.getMessage() + ")");
                    List<String> newUrls = new ArrayList<String>();
                    for (String newUrl : urls ){
                        if (!newUrl.equals(apiUrl)){
                            newUrls.add(newUrl);
                        }
                    }
                    if (newUrls.isEmpty()){
                        isBatchReporting = false;
                        BISLog.e(this.getClass().getName(), "Failed to report batch event.");
                    }else {
                        reportBatchEvent(newUrls, events);
                    }
                }
            }else{
                isBatchReporting = false;
            }
        }else{
            isBatchReporting = false;
        }
    }

    private void removeEvent(BISCollectionEvent eventToDelete){
        synchronized (buffer) {
            for (int i = 0; i < buffer.length; i++) {
                BISCollectionEvent event = buffer[i];
                if (event != null) {
                    if (event.equals(eventToDelete)) {
                        buffer[i] = null;
                    }
                }
            }
        }
    }
}
