package com.beaconsinspace.android.beacon.detector;

import android.content.SharedPreferences;

import static android.content.Context.MODE_PRIVATE;

/**
 * Created by johnlfoleyiii on 12/13/16.
 */

class BISPersistentStorage
{

    static private final String sharedPreferencesFile="BIS_PERSISTENT_STORAGE";
    private static final String KEY_IS_DEVICE_METADATA_COLLECTED = "KEY_IS_DEVICE_METADATA_COLLECTED";
    static private SharedPreferences sharedPreferences;
    static final String KEY_APIKEY="BIS_API_KEY";
    static final String KEY_DEVICE_METADATA = "KEY_DEVICEATLAS_DATA";
    private static final String KEY_IS_DEVICE_METADATA_SENT = "KEY_IS_DEVICE_METADATA_SENT";

    private static SharedPreferences getSharedPreferences()
    {
        if ( sharedPreferences == null ) {
            sharedPreferences = BISDetector.appContext.getSharedPreferences( sharedPreferencesFile, MODE_PRIVATE );
        }
        return sharedPreferences;
    }

    static void storeString( String key, String value )
    {
        SharedPreferences sharedPreferences = getSharedPreferences();
        SharedPreferences.Editor sharedPreferencesEditor = sharedPreferences.edit();
        sharedPreferencesEditor.putString( key, value );
        sharedPreferencesEditor.commit(); // we want to commit and not apply so the value exists in storage immediately
    }

    static String getString( String key )
    {
        SharedPreferences sharedPreferences = getSharedPreferences();
        return sharedPreferences.getString( key, null );
    }

    static boolean isdeviceMetaDataSent(){
        return getSharedPreferences().getBoolean(KEY_IS_DEVICE_METADATA_SENT, false);
    }

    static void setDeviceMetaDataSent(boolean isDataSent){
        getSharedPreferences().edit().putBoolean(KEY_IS_DEVICE_METADATA_SENT, isDataSent).commit();
    }

    public static boolean isDeviceMetaDataCollected() {
        return getSharedPreferences().getBoolean(KEY_IS_DEVICE_METADATA_COLLECTED, false);
    }

    public static void setDeviceMetaDataCollected(boolean isDeviceMetaDataCollected){
        getSharedPreferences().edit().putBoolean(KEY_IS_DEVICE_METADATA_COLLECTED, isDeviceMetaDataCollected).commit();
    }

    public static String getDeviceMetaDataString() {
        return getString(KEY_DEVICE_METADATA);
    }

    public static void storeDeviceMetaData(String jsonStr) {
        storeString(KEY_DEVICE_METADATA, jsonStr);
    }
}
