package com.beaconsinspace.android.beacon.detector;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;

import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by kyleshank on 10/12/17.
 */

@TargetApi(26)
public class BISJobService extends JobService {
    private Timer timer;
    private TimerTask timerTask;

    @Override
    public boolean onStartJob(final JobParameters jobParameters) {
        BISDetector detector = BISDetector.getSharedInstance();
        if(BISDetector.appContext == null) {
            String apiKey = BISPersistentStorage.getString(BISPersistentStorage.KEY_APIKEY);
            if (apiKey == null) {
                return false;
            }
            detector.bootstrap(apiKey, this.getApplicationContext());
        }

        Integer interval = BISConfiguration.getCurrentConfiguration().backgroundDataCollectionMaxLength;

        BISCollectionManager collectionManager = BISDetector.getSharedInstance().getCollectionManager(this.getApplicationContext());
        if (collectionManager != null) {
            collectionManager.startLocationGathering();
            timer = new Timer();
            timerTask = new TimerTask() {
                public void run() {
                    jobFinished(jobParameters, false);
                }
            };
            timer.schedule(timerTask, (long)interval);
            return true;
        }

        return false;
    }

    @Override
    public boolean onStopJob(JobParameters jobParameters) {
        BISCollectionManager collectionManager = BISDetector.getSharedInstance().getCollectionManager(this.getApplicationContext());
        if (collectionManager != null) {
            collectionManager.stopLocationGathering();
        }
        return false;
    }
}
