/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISBeaconReceiver;
import com.beaconsinspace.android.beacon.detector.BISCollectionEvent;
import com.beaconsinspace.android.beacon.detector.BISConfiguration;
import com.beaconsinspace.android.beacon.detector.BISDetectorRSSICollector;
import com.beaconsinspace.android.beacon.detector.BISGeofenceTransitionsIntentService;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISNetworking;
import com.beaconsinspace.android.beacon.detector.BISReportingManager;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.startup.RegionBootstrap;

public class BISCollectionManager
implements LocationListener,
OnCompleteListener<Void>,
BeaconConsumer,
Application.ActivityLifecycleCallbacks {
    private static final String TAG = "BIS_COLLECTION_MANAGER";
    private static final Long BEACON_EXIT_THRESHOLD = 30000L;
    private Context context = null;
    private BISReportingManager reportingManager;
    private BISCollectionEvent lastEvent;
    private GeofencingClient mGeofencingClient;
    private PendingIntent mGeofencePendingIntent;
    private List<Geofence> mGeofenceList;
    private Location lastLocation;
    private BeaconManager beaconManager = null;
    private RegionBootstrap regionBootstrap;
    private Timer timer;
    private TimerTask timerTask;
    private Timer stickyIdleTimer;
    private TimerTask stickyIdleTimerTask;
    private boolean stickyService = true;
    private List<Timer> intervalTimers = new ArrayList<Timer>();
    private static final ConcurrentHashMap<Beacon, Long> beaconTimestampMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Beacon, BISDetectorRSSICollector> beaconRssiMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> lastTriggerEvents = new ConcurrentHashMap();
    private Timer permissionsTimer;
    private TimerTask permissionsTimerTask;
    private Timer eventCollectionFilterTimer;
    private TimerTask eventCollectionFilterTimerTask;
    private List<BISCollectionEvent> gpsBuffer = new ArrayList<BISCollectionEvent>();

    public BISCollectionManager(Context context) {
        this.context = context;
        this.reportingManager = new BISReportingManager(context);
        this.beaconManager = BeaconManager.getInstanceForApplication((Context)context);
        this.stickyService = Build.VERSION.SDK_INT < 26;
        this.mGeofencingClient = LocationServices.getGeofencingClient((Context)this.context);
        this.mGeofenceList = new ArrayList<Geofence>();
        this.lastLocation = null;
        this.startLocationManager();
        this.startBeaconManager();
        if (context instanceof Application) {
            Application application = (Application)context;
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        BISLog.d(TAG, "Collection Manager started.");
    }

    private void startLocationManager() {
        this.startLocationGathering();
    }

    public Location getLastKnownLocation() {
        return this.lastLocation;
    }

    public void onLocationChanged(Location location) {
        this.lastLocation = location;
        BISCollectionEvent event = new BISCollectionEvent(this.context, BISCollectionEvent.BISCollectionEventType.GPS, location);
        this.saveGPSEvent(event);
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        BISLog.d(this.getClass().getName(), "onStatusChanged(" + status + ")");
    }

    public void onProviderEnabled(String provider) {
        BISLog.d(this.getClass().getName(), "onProviderEnabled(" + provider + ")");
    }

    public void onProviderDisabled(String provider) {
        BISLog.d(this.getClass().getName(), "onProviderDisabled(" + provider + ")");
    }

    public void triggerEvent(BISCollectionEvent event) {
        long diff;
        this.saveEvent(event);
        String uniqueId = event.getUniqueId();
        BISLog.d(this.getClass().getName(), "Triggered by event: " + uniqueId);
        boolean shouldGather = true;
        Date now = new Date();
        Long lastValue = this.lastTriggerEvents.get(uniqueId);
        if (lastValue != null && (double)(diff = now.getTime() - lastValue) < 600000.0) {
            shouldGather = false;
            BISLog.d(this.getClass().getName(), "Skipping location gathering. Similar event was trigged " + (double)diff / 1000.0 + " seconds ago.");
        }
        if (shouldGather) {
            this.lastTriggerEvents.put(uniqueId, now.getTime());
            try {
                this.startLocationGathering();
            }
            catch (SecurityException e) {
                BISLog.e(TAG, e.getMessage());
            }
        }
    }

    public void startLocationGathering() {
        if (!this.isCollectingLocationData()) {
            if (this.permissionsTimer != null) {
                this.permissionsTimer.cancel();
            }
            this.permissionsTimer = null;
            this.permissionsTimerTask = null;
            BISLog.d(TAG, "START LOCATION GATHERING");
            try {
                LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
                locationManager.requestLocationUpdates("passive", 0L, 0.0f, (LocationListener)this, Looper.getMainLooper());
                locationManager.requestLocationUpdates("gps", 0L, 0.0f, (LocationListener)this, Looper.getMainLooper());
                locationManager.requestLocationUpdates("network", 0L, 0.0f, (LocationListener)this, Looper.getMainLooper());
                this.fetchRegions();
                Integer interval = BISConfiguration.getCurrentConfiguration().backgroundDataCollectionMaxLength;
                if (this.stickyService && this.stickyIdleTimer != null) {
                    this.stickyIdleTimer.cancel();
                    this.stickyIdleTimer = null;
                    this.stickyIdleTimerTask = null;
                }
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                this.timer = new Timer();
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            BISCollectionManager.this.stopLocationGathering();
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                };
                this.timer.schedule(this.timerTask, interval.intValue());
                if (!BISConfiguration.getCurrentConfiguration().urlBatchEvent.isEmpty() && !BISConfiguration.getCurrentConfiguration().batchEventInterval.isEmpty()) {
                    for (Timer existingTimer : this.intervalTimers) {
                        existingTimer.cancel();
                    }
                    this.intervalTimers.clear();
                    for (Integer intervalValue : BISConfiguration.getCurrentConfiguration().batchEventInterval) {
                        Timer intervalTimer = new Timer();
                        TimerTask intervalTimerTask = new TimerTask(){

                            @Override
                            public void run() {
                                BISCollectionManager.this.reportingManager.report();
                            }
                        };
                        intervalTimer.schedule(intervalTimerTask, intervalValue.intValue());
                        this.intervalTimers.add(intervalTimer);
                    }
                }
            }
            catch (SecurityException exception) {
                BISLog.d(this.getClass().getName(), "startLocationGathering() " + exception.getMessage());
                this.permissionsTimer = new Timer();
                this.permissionsTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            BISCollectionManager.this.startLocationGathering();
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                };
                this.permissionsTimer.schedule(this.permissionsTimerTask, 10000L);
            }
        }
    }

    protected void stopLocationGathering() throws SecurityException {
        this.timer = null;
        this.timerTask = null;
        for (Timer existingTimer : this.intervalTimers) {
            existingTimer.cancel();
        }
        this.intervalTimers.clear();
        if (this.eventCollectionFilterTimer != null) {
            this.eventCollectionFilterTimer.cancel();
            this.eventCollectionFilterTimer.purge();
            this.eventCollectionFilterTimer = null;
            this.eventCollectionFilterTimerTask = null;
        }
        this.flushGPSEvents();
        this.reportingManager.report();
        BISLog.d(TAG, "STOP LOCATION GATHERING");
        LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
        locationManager.removeUpdates((LocationListener)this);
        locationManager.requestLocationUpdates("passive", 0L, 0.0f, (LocationListener)this, Looper.getMainLooper());
        if (this.stickyService) {
            Integer interval = BISConfiguration.getCurrentConfiguration().locationMonitoringInterval;
            this.stickyIdleTimer = new Timer();
            this.stickyIdleTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        BISCollectionManager.this.startLocationGathering();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            };
            this.stickyIdleTimer.schedule(this.stickyIdleTimerTask, interval.intValue());
        }
    }

    private boolean isCollectingLocationData() {
        return this.timer != null;
    }

    private void saveEvent(BISCollectionEvent event) {
        BISLog.d(TAG, "Saved " + event.getEventType() + " event.");
        this.reportingManager.addEvent(event);
        boolean firstFetch = this.lastEvent == null;
        this.lastEvent = event;
        if (firstFetch) {
            this.fetchRegions();
        }
    }

    private void saveGPSEvent(BISCollectionEvent event) {
        Integer interval = BISConfiguration.getCurrentConfiguration().eventCollectionFilterLength;
        if (interval == 0) {
            this.saveEvent(event);
            return;
        }
        this.gpsBuffer.add(event);
        if (this.eventCollectionFilterTimer != null) {
            this.eventCollectionFilterTimer = new Timer();
            this.eventCollectionFilterTimerTask = new TimerTask(){

                @Override
                public void run() {
                    BISCollectionManager.this.flushGPSEvents();
                }
            };
            this.eventCollectionFilterTimer.scheduleAtFixedRate(this.eventCollectionFilterTimerTask, interval.intValue(), (long)interval.intValue());
        }
    }

    private void flushGPSEvents() {
        BISCollectionEvent bestEvent = null;
        for (BISCollectionEvent event : this.gpsBuffer) {
            if (bestEvent == null) {
                bestEvent = event;
                continue;
            }
            if (bestEvent.location == null || event.location == null) continue;
            float bestEventAccuracy = bestEvent.location.getAccuracy();
            float eventAccuracy = event.location.getAccuracy();
            if (!(eventAccuracy < bestEventAccuracy)) continue;
            bestEvent = event;
        }
        this.gpsBuffer.clear();
        if (bestEvent != null) {
            this.saveEvent(bestEvent);
        }
    }

    private void fetchRegions() {
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            BISLog.d(this.getClass().getName(), "fetchRegions() ACCESS_FINE_LOCATION not granted");
            return;
        }
        if (this.lastLocation == null) {
            BISLog.d(this.getClass().getName(), "fetchRegions() needs a last location");
            return;
        }
        this.mGeofencingClient.removeGeofences(this.getGeofencePendingIntent());
        List<Geofence> newGeofences = this.getGeofences();
        if (newGeofences != null) {
            this.mGeofenceList.clear();
            this.mGeofenceList.addAll(newGeofences);
        }
        if (!this.mGeofenceList.isEmpty()) {
            this.mGeofencingClient.addGeofences(this.getGeofencingRequest(), this.getGeofencePendingIntent());
        }
    }

    private List<Geofence> getGeofences() {
        return this.getGeofences(BISConfiguration.getCurrentConfiguration().urlGeofence);
    }

    private List<Geofence> getGeofences(List<String> apiUrls) {
        BISLog.d(TAG, "COLLECTING GEO-FENCE CONFIGURATION");
        if (this.getLastKnownLocation() == null || apiUrls == null || apiUrls.isEmpty()) {
            return null;
        }
        String apiUrl = apiUrls.get(0);
        try {
            List<Geofence> geofences = BISNetworking.getSharedManger().getGeofences(apiUrl, this.getLastKnownLocation());
            return geofences;
        }
        catch (Exception e) {
            ArrayList<String> newUrls = new ArrayList<String>();
            for (String newUrl : apiUrls) {
                if (newUrl.equals(apiUrl)) continue;
                newUrls.add(newUrl);
            }
            return this.getGeofences(newUrls);
        }
    }

    public void onComplete(@NonNull Task<Void> task) {
    }

    private GeofencingRequest getGeofencingRequest() {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences(this.mGeofenceList);
        return builder.build();
    }

    private PendingIntent getGeofencePendingIntent() {
        if (this.mGeofencePendingIntent != null) {
            return this.mGeofencePendingIntent;
        }
        Intent intent = new Intent(this.context, BISGeofenceTransitionsIntentService.class);
        this.mGeofencePendingIntent = PendingIntent.getService((Context)this.context, (int)0, (Intent)intent, (int)0x8000000);
        return this.mGeofencePendingIntent;
    }

    private void startBeaconManager() {
        if (!BISConfiguration.getCurrentConfiguration().isModelSupportedForBluetoothUse()) {
            return;
        }
        String iBeaconLayout = "m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24";
        this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(iBeaconLayout));
        String altBeaconLayout = "m:2-3=beac,i:4-19,i:20-21,i:22-23,p:24-24,d:25-25";
        this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(altBeaconLayout));
        String eddystoneUIDBeaconLayout = "s:0-1=feaa,m:2-2=00,p:3-3:-41,i:4-13,i:14-19";
        this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(eddystoneUIDBeaconLayout));
        String eddystoneURLBeaconLayout = "s:0-1=feaa,m:2-2=10,p:3-3:-41,i:4-20v";
        this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(eddystoneURLBeaconLayout));
        this.setBeaconScanPeriods();
        if (Build.VERSION.SDK_INT >= 26) {
            BluetoothAdapter bluetoothAdapter;
            ScanSettings settings = new ScanSettings.Builder().setScanMode(0).build();
            BluetoothManager bluetoothManager = (BluetoothManager)this.context.getApplicationContext().getSystemService("bluetooth");
            if (bluetoothManager != null && (bluetoothAdapter = bluetoothManager.getAdapter()) != null) {
                Intent intent = new Intent(this.context, BISBeaconReceiver.class);
                intent.putExtra("o-scan", true);
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)0x8000000);
                BluetoothLeScanner scanner = bluetoothAdapter.getBluetoothLeScanner();
                if (scanner != null) {
                    try {
                        scanner.startScan(null, settings, pendingIntent);
                    }
                    catch (Exception permissionException) {
                        BISLog.e(TAG, "RuntimeException likely. BLUETOOTH_PRIVILEGED not granted? " + permissionException.getMessage());
                    }
                }
            }
        }
    }

    private void setBeaconScanPeriods() {
        if (this.beaconManager == null) {
            return;
        }
        this.beaconManager.setForegroundScanPeriod((long)BISConfiguration.getCurrentConfiguration().foregroundBluetoothScanPeriod.intValue());
        this.beaconManager.setForegroundBetweenScanPeriod((long)BISConfiguration.getCurrentConfiguration().foregroundBluetoothBetweenScanPeriod.intValue());
        this.beaconManager.setBackgroundScanPeriod((long)BISConfiguration.getCurrentConfiguration().backgroundBluetoothScanPeriod.intValue());
        this.beaconManager.setBackgroundBetweenScanPeriod((long)BISConfiguration.getCurrentConfiguration().backgroundBluetoothBetweenScanPeriod.intValue());
        this.doBindBeaconManager();
        if (this.beaconManager.isBound((BeaconConsumer)this)) {
            try {
                this.beaconManager.updateScanPeriods();
            }
            catch (RemoteException e) {
                BISLog.e(TAG, e.getMessage());
            }
        }
    }

    public void onBeaconServiceConnect() {
        try {
            this.beaconManager.setRangeNotifier(new RangeNotifier(){

                public void didRangeBeaconsInRegion(Collection<Beacon> collection, Region region) {
                    Long beaconLastSeenTimestamp;
                    Long currentTimestamp = System.currentTimeMillis();
                    for (Beacon beacon : collection) {
                        beaconLastSeenTimestamp = (Long)beaconTimestampMap.get(beacon);
                        if (beaconLastSeenTimestamp == null) {
                            BISLog.d(BISCollectionManager.TAG, "ENTERED BEACON " + BISCollectionManager.this.uniqueIdentifierForBeacon(beacon));
                            BISCollectionManager.this.handleBeaconEnter(beacon);
                            beaconRssiMap.put(beacon, new BISDetectorRSSICollector());
                        }
                        BISDetectorRSSICollector rssiCollector = (BISDetectorRSSICollector)beaconRssiMap.get(beacon);
                        rssiCollector.add(beacon.getRssi());
                        beaconRssiMap.put(beacon, rssiCollector);
                        beaconTimestampMap.put(beacon, currentTimestamp);
                    }
                    for (Beacon beacon : beaconTimestampMap.keySet()) {
                        beaconLastSeenTimestamp = (Long)beaconTimestampMap.get(beacon);
                        Long diff = currentTimestamp - beaconLastSeenTimestamp;
                        if (diff <= BEACON_EXIT_THRESHOLD) continue;
                        BISLog.d(BISCollectionManager.TAG, "EXITED BEACON " + BISCollectionManager.this.uniqueIdentifierForBeacon(beacon));
                        BISCollectionManager.this.handleBeaconExit(beacon);
                        beaconTimestampMap.remove(beacon);
                    }
                }
            });
            this.beaconManager.startRangingBeaconsInRegion(new Region("ALL_BEACONS", null, null, null));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("RemoteException: " + e.toString()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception: " + e.toString()));
        }
    }

    public Context getApplicationContext() {
        return this.context;
    }

    public void unbindService(ServiceConnection serviceConnection) {
        try {
            this.context.unbindService(serviceConnection);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        try {
            return this.context.bindService(intent, serviceConnection, i);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return false;
        }
    }

    private void doBindBeaconManager() {
        try {
            if (this.beaconManager != null && !this.beaconManager.isBound((BeaconConsumer)this)) {
                this.beaconManager.bind((BeaconConsumer)this);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Failed to bind: " + e.toString()));
        }
    }

    private void undoBindBeaconManager() {
        try {
            if (this.beaconManager != null && this.beaconManager.isBound((BeaconConsumer)this)) {
                this.beaconManager.unbind((BeaconConsumer)this);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Failed to unbind: " + e.toString()));
        }
    }

    public void startRanging() {
        try {
            this.stopRanging();
            this.doBindBeaconManager();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception: " + e.toString()));
        }
    }

    public void stopRanging() {
        try {
            Collection regions = this.beaconManager.getRangedRegions();
            for (Region region : regions) {
                this.beaconManager.stopRangingBeaconsInRegion(region);
            }
            this.undoBindBeaconManager();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("RemoteException: " + e.toString()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception: " + e.toString()));
        }
    }

    private void handleBeaconEnter(Beacon beacon) {
        BISCollectionEvent event = new BISCollectionEvent(this.context, BISCollectionEvent.BISCollectionEventType.BeaconInteraction, BISCollectionEvent.BISCollectionEventDirection.Enter, beacon);
        event.location = this.lastLocation;
        this.triggerEvent(event);
    }

    private void handleBeaconExit(Beacon beacon) {
        BISCollectionEvent event = new BISCollectionEvent(this.context, BISCollectionEvent.BISCollectionEventType.BeaconInteraction, BISCollectionEvent.BISCollectionEventDirection.Exit, beacon, beaconRssiMap.get(beacon));
        event.location = this.lastLocation;
        this.triggerEvent(event);
    }

    private static String beaconIdentifierToString(Identifier i) {
        try {
            if (i == null) {
                return null;
            }
            String s = i.toString();
            if (s == null) {
                return null;
            }
            if (s.length() >= 2 && s.substring(0, 2).equals("0x")) {
                s = s.substring(2);
            }
            return s;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception: " + e.getMessage()));
            return null;
        }
    }

    private String[] idsForBeacon(Beacon beacon) {
        if (beacon == null) {
            return new String[]{"", "", ""};
        }
        Identifier id1 = null;
        Identifier id2 = null;
        Identifier id3 = null;
        try {
            id1 = beacon.getIdentifiers().size() > 0 ? beacon.getId1() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            id2 = beacon.getIdentifiers().size() > 1 ? beacon.getId2() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            id3 = beacon.getIdentifiers().size() > 2 ? beacon.getId3() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String ID1 = id1 != null ? BISCollectionManager.beaconIdentifierToString(id1) : "";
        String ID2 = id2 != null ? BISCollectionManager.beaconIdentifierToString(id2) : "";
        String ID3 = id3 != null ? BISCollectionManager.beaconIdentifierToString(id3) : "";
        return new String[]{ID1, ID2, ID3};
    }

    private String uniqueIdentifierForBeacon(Beacon beacon) {
        if (beacon == null) {
            return "";
        }
        String s = null;
        try {
            String[] strings = this.idsForBeacon(beacon);
            String id1 = strings[0];
            String id2 = strings[1];
            String id3 = strings[2];
            String uniqueId = id1 + "_" + id2 + "_" + id3;
            s = id1 + ":" + uniqueId.hashCode();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception: " + e.getMessage()));
        }
        return s;
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        this.startLocationGathering();
    }

    public void onActivityPaused(Activity activity) {
        this.reportingManager.report();
    }

    public void onActivityStopped(Activity activity) {
        this.reportingManager.report();
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

