/*
 * Copyright (c) Afilias Technologies Ltd 2017. All rights reserved.
 */


package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;

/**
 * @author Afilias Technologies Ltd
 */
class StorageProperties {
    private static final String TAG = StorageProperties.class.getName();

    private static final int MEGABYTE = 1024*1024;

    private static final String MAX_INTERNAL_STORAGE_MB = "maxInternalStorageMB";
    private static final String MAX_EXTERNAL_STORAGE_MB = "maxExternalStorageMB";
    private static final String IS_EXTERNAL_STORAGE_EMULATED = "isExternalStorageEmulated";


    public static JSONObject getProperties() throws JSONException {
        JSONObject props = new JSONObject();

        props.put(MAX_INTERNAL_STORAGE_MB, getStorageTotalSizeMB(Environment.getRootDirectory()));
        props.put(MAX_EXTERNAL_STORAGE_MB, getStorageTotalSizeMB(Environment.getExternalStorageDirectory()));

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            props.put(IS_EXTERNAL_STORAGE_EMULATED, Environment.isExternalStorageEmulated());
        }

        return props;
    }


    private static long getStorageTotalSizeMB(File path) {
        long totalBytes = 0;

        try {
            StatFs stat = new StatFs(path.getPath());
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR2) {
                totalBytes = stat.getBlockSizeLong() * stat.getBlockCountLong();
            } else {
                totalBytes = (long) stat.getBlockSize() * (long) stat.getBlockCount();
            }
        } catch(IllegalArgumentException ex) {
            // some environments throw this if passed an invalid path even though we request the
            // paths by calling Environment.getXXXXX.
            Log.d(TAG, ex.toString());
        }

        return totalBytes / MEGABYTE;
    }


}
