/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISDetectorInternalDelegate;
import com.beaconsinspace.android.beacon.detector.BISLog;

public class BISDetectorServicesListener
extends BroadcastReceiver {
    private static final String TAG = "BIS_LISTENER";
    static BISDetectorInternalDelegate delegate;

    public static void setDelegate(BISDetectorInternalDelegate _delegate) {
        delegate = _delegate;
    }

    public void onReceive(Context context, Intent intent) {
        if (delegate == null) {
            return;
        }
        String action = intent.getAction();
        BISLog.i(TAG, "Intent action: " + action);
        if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
            switch (state) {
                case 10: {
                    BISDetector.stopRanging();
                    break;
                }
                case 13: {
                    break;
                }
                case 12: {
                    BISDetector.startRanging();
                    break;
                }
                case 11: {
                    break;
                }
            }
        } else if (intent.getAction().matches("android.location.PROVIDERS_CHANGED")) {
            if (BISDetector.isLocationServiceEnabled()) {
                BISDetector.startRanging();
            } else {
                BISDetector.stopRanging();
            }
        }
    }
}

