/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.provider.Settings;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISConfiguration;
import com.beaconsinspace.android.beacon.detector.BISDetectorDelegate;
import com.beaconsinspace.android.beacon.detector.BISDetectorInternalDelegate;
import com.beaconsinspace.android.beacon.detector.BISDetectorManager;
import com.beaconsinspace.android.beacon.detector.BISDetectorREST;
import com.beaconsinspace.android.beacon.detector.BISDetectorServicesListener;
import com.beaconsinspace.android.beacon.detector.BISDeviceAtlas;
import com.beaconsinspace.android.beacon.detector.BISDeviceUUID;
import com.beaconsinspace.android.beacon.detector.BISLocationListener;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISPersistentStorage;
import com.beaconsinspace.android.beacon.detector.BISProcessManager;
import com.beaconsinspace.android.beacon.detector.fgchecker.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;

public class BISDetector
extends Service
implements BISDetectorInternalDelegate {
    public static String SDK_VERSION = "1.3.9.4";
    private static final String TAG = "BIS_API";
    static String API_KEY = "";
    static String ADID = "";
    static UUID UUID;
    static BISDetector sharedInstance;
    static BISDetectorManager beaconsManager;
    static BISDetectorDelegate delegate;
    private Thread primaryProcessThread;
    private static Thread continuousLocationMonitoringThread;
    private static Thread continuousConfigurationMonitoringThread;
    static Context appContext;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private BISProcessManager bisProcessManager;

    public static void configure(String key, Context ctx, BISDetectorDelegate dlgt) {
        Log.d((String)TAG, (String)("Configuring BISDetector SDK " + SDK_VERSION));
        API_KEY = key;
        appContext = ctx.getApplicationContext();
        delegate = dlgt;
        BISPersistentStorage.storeString("BIS_API_KEY", key);
        sharedInstance.getInstalledApps(appContext);
        if (!BISPersistentStorage.isDeviceMetaDataCollected()) {
            sharedInstance.bootDeviceAtlas();
        }
        appContext.sendBroadcast(new Intent("BootstrapBeaconsInSpace"));
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        appContext = this.getApplicationContext();
        API_KEY = BISPersistentStorage.getString("BIS_API_KEY");
        if (this.primaryProcessThread == null) {
            this.primaryProcessThread = new Thread(){

                @Override
                public void run() {
                    try {
                        BISDetector.this.bootstrap(API_KEY, appContext);
                    }
                    catch (Throwable e) {
                        BISLog.e(BISDetector.TAG, e.getMessage());
                    }
                }
            };
            this.primaryProcessThread.start();
        }
        return 1;
    }

    private void bootstrap(String key, Context ctx) {
        API_KEY = key != null ? key : "";
        BISConfiguration.update();
        String processCollectionConfig = BISConfiguration.get("collectForegroundProcess");
        BISLog.i(TAG, "processCollectionConfig: " + processCollectionConfig);
        if (processCollectionConfig.equals("1")) {
            sharedInstance.requestUsageStatsPermission();
        }
        if (!BISDetector.isSafeToBootstrap()) {
            Log.d((String)TAG, (String)"This device is not supported. BeaconsInSpace Detector shutting down");
            return;
        }
        BISDeviceUUID deviceUUID = new BISDeviceUUID(ctx);
        UUID = deviceUUID.getDeviceUuid();
        BISDetector.getUserADID();
        beaconsManager.setContextAndInit(ctx);
        if (!processCollectionConfig.equals("-1")) {
            BISLog.i(TAG, "Starting background process collection");
            try {
                BISDetector.sharedInstance.bisProcessManager = new BISProcessManager(appContext);
                this.mHandlerThread = new HandlerThread("ActiveProcessesThread");
                this.mHandlerThread.start();
                this.mHandler = new Handler(this.mHandlerThread.getLooper());
                this.runAppProcessesHandler();
            }
            catch (Exception e) {
                BISLog.e(TAG, "Error starting Process Collection", e);
            }
        }
        BISDetector internalDelegate = sharedInstance;
        BISDetectorREST.setDelegate(internalDelegate);
        BISDetectorServicesListener.setDelegate(internalDelegate);
        BISDetectorManager.setDelegate(internalDelegate);
    }

    public IBinder onBind(Intent arg0) {
        return null;
    }

    public void onDestroy() {
        this.sendBroadcast(new Intent("BootstrapBeaconsInSpace"));
        super.onDestroy();
    }

    private static boolean isSafeToBootstrap() {
        if (Build.VERSION.SDK_INT < 18) {
            Log.e((String)TAG, (String)("BeaconsInSpace Detector Library does not run on Android: " + Build.VERSION.SDK_INT));
            return false;
        }
        return true;
    }

    private static boolean isModelSupportedForBluetoothUse() {
        ArrayList<String> unsupportedDeviceModels = new ArrayList<String>();
        try {
            String unsupportedDeviceModelsJSONString = BISConfiguration.get("unsupportedAndroidModels");
            JSONArray unsupportedDeviceModelsJSONArray = new JSONArray(unsupportedDeviceModelsJSONString);
            for (int i = 0; i < unsupportedDeviceModelsJSONArray.length(); ++i) {
                unsupportedDeviceModels.add(unsupportedDeviceModelsJSONArray.getString(i));
            }
        }
        catch (JSONException jsonException) {
            BISLog.e(TAG, "JsonException occurred while retrieving unsupportedDeviceModels.", (Exception)((Object)jsonException));
        }
        String deviceModel = Build.MODEL;
        for (String unsupportedModel : unsupportedDeviceModels) {
            if (!deviceModel.equals(unsupportedModel)) continue;
            BISLog.e(TAG, "BeaconsInSpace Detector Library does not run on Android Model " + unsupportedModel + " due to Networking/Bluetooth collision issues.");
            return false;
        }
        return true;
    }

    public static void setBeaconManagerScanPeriods(Long foregroundScanPeriod, Long foregroundBetweenScanPeriod, Long backgroundScanPeriod, Long backgroundBetweenScanPeriod) {
        beaconsManager.setScanPeriods(foregroundScanPeriod, foregroundBetweenScanPeriod, backgroundScanPeriod, backgroundBetweenScanPeriod);
    }

    static void performInitialSetup() {
        String errorMessage = "";
        if (!BISDetector.isLocationServiceEnabled()) {
            errorMessage = "Location Services are not enabled. Please enable them in Settings.";
            Log.e((String)TAG, (String)errorMessage);
            if (delegate != null) {
                delegate.onBISError(409, errorMessage);
            }
            return;
        }
        if (!BISDetector.isInternetAvailable()) {
            errorMessage = "Network Services are not enabled. Please enable them in Settings.";
            Log.e((String)TAG, (String)errorMessage);
            if (delegate != null) {
                delegate.onBISError(409, errorMessage);
            }
            return;
        }
        if (!BISDetector.isBluetoothEnabled()) {
            errorMessage = "Bluetooth is not enabled. Please turn it on to proceed";
            Log.e((String)TAG, (String)errorMessage);
            if (delegate != null) {
                delegate.onBISError(409, errorMessage);
            }
            return;
        }
        if (BISDetector.isModelSupportedForBluetoothUse()) {
            BISDetector.startRanging();
        }
        BISDetector.beginLocationMonitoring();
        BISDetector.beginConfigurationMonitoring();
        Log.i((String)TAG, (String)"BeaconsInSpace has bootstrapped successfully");
    }

    static BISDetectorManager beaconsManager() {
        return beaconsManager;
    }

    static void getUserADID() {
        if (appContext == null) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        thread.start();
    }

    public static boolean isLocationServiceEnabled() {
        if (appContext == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            int locationMode = 0;
            try {
                locationMode = Settings.Secure.getInt((ContentResolver)appContext.getContentResolver(), (String)"location_mode");
            }
            catch (Settings.SettingNotFoundException e) {
                Log.e((String)TAG, (String)("Failed to check for location services: " + e.getMessage()));
                return false;
            }
            return locationMode != 0;
        }
        LocationManager lm = (LocationManager)appContext.getSystemService("location");
        boolean gps_enabled = false;
        boolean network_enabled = false;
        try {
            gps_enabled = lm.isProviderEnabled("gps");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            network_enabled = lm.isProviderEnabled("network");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gps_enabled || network_enabled;
    }

    public static boolean isInternetAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)appContext.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static boolean isBluetoothEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null) {
            return false;
        }
        return adapter.isEnabled();
    }

    public static void startRanging() {
        beaconsManager.setContextAndInit(appContext);
        beaconsManager.startRanging();
        Log.d((String)TAG, (String)"BLE ranging has begun");
    }

    public static void stopRanging() {
        beaconsManager.stopRanging();
    }

    static void onUserADIDReceiveSuccess() {
        BISDetector.performInitialSetup();
    }

    static void onUserADIDReceiveFail() {
        BISDetector.performInitialSetup();
    }

    @Override
    public void onBeaconEnter(String beaconId) {
        if (delegate != null) {
            delegate.didEnterBISRegion(beaconId);
        }
    }

    @Override
    public void onBeaconExit(String beaconId) {
        if (delegate != null) {
            delegate.didExitBISRegion(beaconId);
        }
    }

    private static void beginLocationMonitoring() {
        if (continuousLocationMonitoringThread == null) {
            continuousLocationMonitoringThread = new Thread(){

                @Override
                public void run() {
                    try {
                        String monitorIntervalString;
                        while ((monitorIntervalString = BISConfiguration.get("locationMonitoringInterval")) != null && !monitorIntervalString.equals("0")) {
                            int monitorIntervalInt = Integer.parseInt(monitorIntervalString);
                            String uniqueId = "CONTINUOUS_PROCESSING";
                            BISLocationListener.assignLocationToBeaconId(uniqueId);
                            Thread.sleep(60000L);
                            Location location = BISLocationListener.getLocationByBeaconId(uniqueId);
                            BISDetectorREST.sendGPSEvent(location, true);
                            Thread.sleep(monitorIntervalInt);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            continuousLocationMonitoringThread.start();
        }
    }

    private static void beginConfigurationMonitoring() {
        if (continuousConfigurationMonitoringThread == null) {
            continuousConfigurationMonitoringThread = new Thread(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(10800000L);
                            BISConfiguration.update();
                            beaconsManager.setScanPeriodsFromConfigurationData();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
            };
            continuousConfigurationMonitoringThread.start();
        }
    }

    private void bootDeviceAtlas() {
        Intent transparentActivityIntent = new Intent(appContext, BISDeviceAtlas.class);
        transparentActivityIntent.setFlags(0x10000000);
        appContext.startActivity(transparentActivityIntent);
    }

    private void getInstalledApps(Context context) {
        List apps = context.getPackageManager().getInstalledApplications(128);
    }

    private void runAppProcessesHandler() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    sharedInstance.getBisProcessManager().scanRunningAppProcesses();
                    BISDetector.this.runAppProcessesHandler();
                }
                catch (Exception e) {
                    BISLog.e(BISDetector.TAG, "Exception thrown in process collection", e);
                }
                catch (Throwable e) {
                    BISLog.e(BISDetector.TAG, "Throwable Exception thrown in process collection");
                }
            }
        }, 60000L);
    }

    private void requestUsageStatsPermission() {
        if (Build.VERSION.SDK_INT >= 21 && !Utils.hasUsageStatsPermission(appContext)) {
            Intent permissionActivityIntent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            permissionActivityIntent.setFlags(0x10000000);
            appContext.startActivity(permissionActivityIntent);
        }
    }

    public static Context getContext() {
        return appContext;
    }

    public static void setDebug(boolean isDebug) {
        BISLog.LOGGING_ENABLED = isDebug;
    }

    @Override
    public BISProcessManager getBisProcessManager() {
        return this.bisProcessManager;
    }

    static {
        sharedInstance = new BISDetector();
        beaconsManager = new BISDetectorManager();
    }
}

