package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.util.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.regex.Pattern;

/**
 * @author Afilias Technologies Ltd
 */
class CpuProperties {
    private static final String TAG = CpuProperties.class.getName();

    private static final String AVAILABLE_PROCESSORS = "availableProcessors";
    private static final String NUM_CORES = "numCores";
    private static final String CPU_INFO = "cpuInfo";
    private static final String CPU_MIN_FREQ_KHZ = "cpuMinFreqKhz";
    private static final String CPU_MAX_FREQ_KHZ = "cpuMaxFreqKhz";
    private static final String ARCH = "arch";


    public static JSONObject getProperties() throws JSONException {
        JSONObject props = new JSONObject();

        // from docs: Traditionally this returned the number currently online, but many mobile
        // devices are able to take unused cores offline to save power, so releases newer than
        // Android 4.2 (Jelly Bean) return the maximum number of cores that could be made available
        // if there were no power or heat constraints.
        props.put(AVAILABLE_PROCESSORS, Runtime.getRuntime().availableProcessors());

        // supposedly more reliable...
        props.put(NUM_CORES, getNumCores());

        // return the full cpuinfo file as it's contents differ depending on architecture
        props.put(CPU_INFO, FileUtil.loadAsString("/proc/cpuinfo"));

        props.put(CPU_MIN_FREQ_KHZ, FileUtil.loadFirstLine("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq"));
        props.put(CPU_MAX_FREQ_KHZ, FileUtil.loadFirstLine("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq"));

        props.put(ARCH, StrUtil.asString(System.getProperty("os.arch")));
        return props;
    }




    /**
     * Gets the number of cores available in this device, across all processors.
     * Requires: Ability to access the filesystem at "/sys/devices/system/cpu"
     *
     * From: http://stackoverflow.com/questions/7962155/how-can-you-detect-a-dual-core-cpu-on-an-android-device-from-code
     *
     *
     * @return The number of cores, or 0 if failed to get result
     */
    private static int getNumCores() {
        int count = 0;
        File dir = new File("/sys/devices/system/cpu/"); // directory containing CPU info

        try {
            String[] files = dir.list();

            if (files != null) {
                for (String name : files) {
                    if (Pattern.matches("cpu[0-9]+", name)) {
                        count++;
                    }
                }
            }
        } catch (SecurityException ex) {
            Log.d(TAG, "Could not access dir "+dir.toString());
        }

        return count;
    }


}
