/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Build;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SensorProperties {
    public static JSONArray getProperties(Context context) throws JSONException {
        JSONArray props = new JSONArray();
        SensorManager mgr = (SensorManager)context.getSystemService("sensor");
        List sensors = mgr.getSensorList(-1);
        for (Sensor sensor : sensors) {
            JSONObject s = new JSONObject();
            s.put("name", (Object)sensor.getName());
            s.put("vendor", (Object)sensor.getVendor());
            s.put("maxRange", (double)sensor.getMaximumRange());
            s.put("powerMa", (double)sensor.getPower());
            s.put("resolution", (double)sensor.getResolution());
            s.put("version", sensor.getVersion());
            if (Build.VERSION.SDK_INT >= 9) {
                s.put("minDelayUs", sensor.getMinDelay());
            }
            String type = Build.VERSION.SDK_INT >= 20 ? SensorProperties.cleanType(sensor.getStringType()) : SensorProperties.getTypeFromId(sensor.getType());
            s.put("type", (Object)type);
            if (Build.VERSION.SDK_INT >= 21) {
                s.put("isWakeUpSensor", sensor.isWakeUpSensor());
                s.put("maxDelayUs", sensor.getMaxDelay());
                s.put("reportingMode", (Object)SensorProperties.getReportingMode(sensor.getReportingMode()));
            }
            props.put((Object)s);
        }
        return props;
    }

    private static String getReportingMode(int mode) {
        switch (mode) {
            case 0: {
                return "continuous";
            }
            case 1: {
                return "on_change";
            }
            case 2: {
                return "one_shot";
            }
            case 3: {
                return "SPECIAL_TRIGGER";
            }
        }
        return "id=" + mode;
    }

    private static String cleanType(String type) {
        String prefix = "android.sensor.";
        if (type.startsWith(prefix)) {
            type = type.substring(prefix.length());
        }
        return type;
    }

    private static String getTypeFromId(int type) {
        switch (type) {
            case 1: {
                return "accelerometer";
            }
            case 2: {
                return "magnetic_field";
            }
            case 3: {
                return "orientation";
            }
            case 4: {
                return "gyroscope";
            }
            case 5: {
                return "light";
            }
            case 6: {
                return "pressure";
            }
            case 7: {
                return "temperature";
            }
            case 8: {
                return "proximity";
            }
            case 9: {
                return "gravity";
            }
            case 10: {
                return "linear_acceleration";
            }
            case 11: {
                return "rotation_vector";
            }
            case 12: {
                return "relative_humidity";
            }
            case 13: {
                return "ambient_temperature";
            }
            case 14: {
                return "magnetic_field_uncalibrated";
            }
            case 15: {
                return "game_rotation_vector";
            }
            case 16: {
                return "gyroscope_uncalibrated";
            }
            case 17: {
                return "significant_motion";
            }
            case 18: {
                return "step_detector";
            }
            case 19: {
                return "step_counter";
            }
            case 20: {
                return "geomagnetic_rotation_vector";
            }
            case 21: {
                return "heart_rate";
            }
        }
        return "id=" + type;
    }
}

