/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.os.AsyncTask;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.deviceatlas.DataCourierCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;

public class DataCourier
extends AsyncTask<URL, String, Long> {
    private DataCourierCallback callback;
    private String data = null;
    private String authUser = null;
    private String authPassword = null;

    public DataCourier() {
    }

    public DataCourier(DataCourierCallback callback) {
        this.callback = callback;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setAuthentication(String user, String password) {
        this.authUser = user;
        this.authPassword = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long doInBackground(URL ... urls) {
        BISLog.i("BIS_DA", "DEVICE ATLAS DATA COURIER RUNNING");
        if (this.data == null) {
            this.publishProgress(new String[]{"Data to send is null."});
            return 0L;
        }
        this.publishProgress(new String[]{"Sending data to: " + urls.length + " URLs"});
        Long ret = 0L;
        for (URL dataUrl : urls) {
            this.publishProgress(new String[]{"POST " + dataUrl.toString()});
            HttpURLConnection conn = null;
            OutputStream os = null;
            try {
                if (this.authUser != null && this.authPassword != null) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(DataCourier.this.authUser, DataCourier.this.authPassword.toCharArray());
                        }
                    });
                }
                if ((conn = (HttpURLConnection)dataUrl.openConnection()) != null) {
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Content-Type", "application/json");
                    os = conn.getOutputStream();
                    os.write(this.data.getBytes("UTF-8"));
                    ret = ret + (long)this.data.getBytes().length;
                }
                os.close();
                this.publishProgress(new String[]{this.data.getBytes().length + " bytes sent"});
                this.publishProgress(new String[]{"HTTP response code: " + conn.getResponseCode()});
                conn.disconnect();
            }
            catch (IOException ex) {
                this.publishProgress(new String[]{"Could not send data: " + ex.getMessage()});
                Log.e((String)"Could not send data", (String)ex.getMessage());
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    protected void onProgressUpdate(String ... progress) {
        if (this.callback != null) {
            for (String str : progress) {
                this.callback.statusUpdate(str);
            }
        }
    }

    protected void onPostExecute(Long result) {
        if (this.callback != null) {
            this.callback.taskComplete();
        }
    }
}

