/*
 * Copyright (c) Afilias Technologies Ltd 2017. All rights reserved.
 */


package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.InvocationTargetException;

/**
 * @author Afilias Technologies Ltd
 */
class DisplayProperties {
    private static final String TAG = DisplayProperties.class.getName();

    private static final String X_DPI = "xDpi";
    private static final String y_DPI = "yDpi";
    private static final String WIDTH_PIXELS = "widthPixels";
    private static final String HEIGHT_PIXELS = "heightPixels";

    public static JSONObject getProperties(Context context) throws JSONException {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        Display display = wm.getDefaultDisplay();

        int widthPixels = -1, heightPixels = -1;
        display.getMetrics(metrics); // always get metrics as we need it for DPI values.

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            display.getRealMetrics(metrics); // get real screen size as getMetrics may not represent the real size
            widthPixels = metrics.widthPixels;
            heightPixels = metrics.heightPixels;

        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
            // a more reliable way than via metrics for API >=14 and <17
            try {
                widthPixels = (Integer) Display.class.getMethod("getRawWidth").invoke(display);
                heightPixels = (Integer) Display.class.getMethod("getRawHeight").invoke(display);
            } catch(NoSuchMethodException ex){
                Log.d(TAG, ex.toString());
            } catch (InvocationTargetException ex) {
                Log.d(TAG, ex.toString());
            } catch (IllegalAccessException ex) {
                Log.d(TAG, ex.toString());
            }
        }

        // fallback if API < 14 OR the methods getRawWidth/getRawHeight do not exist
        if(widthPixels == -1 || heightPixels == -1) {
            // Height in particular may not be fully accurate but most older devices don't have onscreen nav buttons
            widthPixels = metrics.widthPixels;
            heightPixels = metrics.heightPixels;
        }

        JSONObject props = new JSONObject();
        props.put(WIDTH_PIXELS, widthPixels);
        props.put(HEIGHT_PIXELS, heightPixels);
        props.put(X_DPI, metrics.xdpi);
        props.put(y_DPI, metrics.ydpi);

        return props;
    }


}
