package com.beaconsinspace.android.beacon.detector;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by johnlfoleyiii on 12/14/16.
 */

class BISConfiguration
{

    private static final String TAG = "BIS_CONFIG";

    static final String KEY_foregroundBluetoothScanPeriod = "foregroundBluetoothScanPeriod";
    static final String KEY_foregroundBluetoothBetweenScanPeriod = "foregroundBluetoothBetweenScanPeriod";
    static final String KEY_backgroundBluetoothScanPeriod = "backgroundBluetoothScanPeriod";
    static final String KEY_backgroundBluetoothBetweenScanPeriod = "backgroundBluetoothBetweenScanPeriod";
    static final String KEY_locationMonitoringInterval = "locationMonitoringInterval";
    static final String KEY_unsupportedAndroidModels = "unsupportedAndroidModels";
    static final String KEY_collectForegroundProcess = "collectForegroundProcess";

    static String get( String key ) {
        String value = BISPersistentStorage.getString( key );
        if ( value == null ) { value = getDefault( key ); }
        return value;
    }

    static void set( String key, String value ) {
        BISPersistentStorage.storeString( key, value );
    }

    private static String getDefault ( String key ) {
        String value=null;
        switch ( key )
        {
            case KEY_foregroundBluetoothScanPeriod:
                value = "2000";
                break;
            case KEY_foregroundBluetoothBetweenScanPeriod:
                value = "60000";
                break;
            case KEY_backgroundBluetoothScanPeriod:
                value = "10000";
                break;
            case KEY_backgroundBluetoothBetweenScanPeriod:
                value = "60000";
                break;
            case KEY_locationMonitoringInterval:
                value = "5340000";
                break;
            case KEY_unsupportedAndroidModels:
                value = "[]";
                break;
            case KEY_collectForegroundProcess:
                /*
                 * -1 = no process collection at all
                 * 0 = background only
                 * 1 = background and foreground
                 */
                value = "-1";
                break;
        }
        return value;
    }

    static boolean update() {
        HashMap<String,String> data = BISDetectorREST.getInitializationData();
        if ( data == null ) { return false; }
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            set(key,value);
        }
        return true;
    }
}
