/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.SharedPreferences;
import com.beaconsinspace.android.beacon.detector.BISDetector;

class BISPersistentStorage {
    private static final String sharedPreferencesFile = "BIS_PERSISTENT_STORAGE";
    private static final String KEY_IS_DEVICE_METADATA_COLLECTED = "KEY_IS_DEVICE_METADATA_COLLECTED";
    private static SharedPreferences sharedPreferences;
    static final String KEY_APIKEY = "BIS_API_KEY";
    static final String KEY_DEVICE_METADATA = "KEY_DEVICEATLAS_DATA";
    private static final String KEY_IS_DEVICE_METADATA_SENT = "KEY_IS_DEVICE_METADATA_SENT";

    BISPersistentStorage() {
    }

    private static SharedPreferences getSharedPreferences() {
        if (sharedPreferences == null) {
            sharedPreferences = BISDetector.appContext.getSharedPreferences(sharedPreferencesFile, 0);
        }
        return sharedPreferences;
    }

    static void storeString(String key, String value) {
        SharedPreferences sharedPreferences = BISPersistentStorage.getSharedPreferences();
        SharedPreferences.Editor sharedPreferencesEditor = sharedPreferences.edit();
        sharedPreferencesEditor.putString(key, value);
        sharedPreferencesEditor.commit();
    }

    static String getString(String key) {
        SharedPreferences sharedPreferences = BISPersistentStorage.getSharedPreferences();
        return sharedPreferences.getString(key, null);
    }

    static boolean isdeviceMetaDataSent() {
        return BISPersistentStorage.getSharedPreferences().getBoolean(KEY_IS_DEVICE_METADATA_SENT, false);
    }

    static void setDeviceMetaDataSent(boolean isDataSent) {
        BISPersistentStorage.getSharedPreferences().edit().putBoolean(KEY_IS_DEVICE_METADATA_SENT, isDataSent).commit();
    }

    public static boolean isDeviceMetaDataCollected() {
        return BISPersistentStorage.getSharedPreferences().getBoolean(KEY_IS_DEVICE_METADATA_COLLECTED, false);
    }

    public static void setDeviceMetaDataCollected(boolean isDeviceMetaDataCollected) {
        BISPersistentStorage.getSharedPreferences().edit().putBoolean(KEY_IS_DEVICE_METADATA_COLLECTED, isDeviceMetaDataCollected).commit();
    }

    public static String getDeviceMetaDataString() {
        return BISPersistentStorage.getString(KEY_DEVICE_METADATA);
    }

    public static void storeDeviceMetaData(String jsonStr) {
        BISPersistentStorage.storeString(KEY_DEVICE_METADATA, jsonStr);
    }
}

