/*
 * Copyright (c) 2008-2016 Afilias Technologies Limited. All rights reserved.
 */

package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.util.Log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Afilias Technologies Ltd
 */
class FileUtil {
    private static final String TAG = FileUtil.class.getName();


    public static String loadFirstLine(String filePath){
        List<String> lines = loadLines(filePath, true);
        if(lines != null && !lines.isEmpty()) {
            return lines.get(0);
        }
        return null;
    }


    public static List<String> loadLines(String filePath){
        return loadLines(filePath, false);
    }



    public static String loadAsString(String filePath){
        List<String> lines = loadLines(filePath, false);
        StringBuilder sb = new StringBuilder();
        for(String s : lines) {
            sb.append(s);
            sb.append("\n");
        }

        return sb.toString();
    }


    private static List<String> loadLines(String filePath, boolean onlyFirstLine) {
        List<String> lines = new ArrayList();

        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(new File(filePath)));
            String line = null;
            while ((line = br.readLine()) != null) {
                lines.add(line.trim());

                if(onlyFirstLine) {
                    break;
                }
            }
        } catch (IOException ex) {
            Log.d(TAG, "Could not read file: " + filePath);
        } finally {
            try {
                if (br != null) {
                    br.close();
                }
            } catch (IOException ex) {/* ignore */}
        }

        return lines;
    }

}
