package com.beaconsinspace.android.beacon.detector;

import android.util.Log;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;


/**
 * Created by johnlfoleyiii on 1/4/17.
 */

class BISShellAccess
{

    private static final String TAG = "BISShellAccess";

    public static Process exec(String cmd) {
        Process process = null;
        try
        {
            process = Runtime.getRuntime().exec(cmd);
            if ( process == null ) { return null; }
            process.waitFor();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return process;
    }

    public static String executeCommandAndGetSpecificLine( String cmd, String prefix, boolean replace )
    {
        try
        {
            Process process = exec ( cmd );
            if ( process != null )
            {
                BufferedReader reader = new BufferedReader( new InputStreamReader( process.getInputStream() ) );
                String line;
                while ( ( line = reader.readLine() ) != null )
                {
                    if (line.startsWith(prefix))
                    {
                        if ( replace )
                        {
                            return line.replace( prefix, "" );
                        }
                        return line;
                    };
                }

            }
        }
        catch( Exception e )
        {
            e.printStackTrace();
        }
        return "";
    }


    public static String executeCommandAndGetAllLines( String cmd )
    {
        String result = "";
        Process process = exec(cmd);
        if ( process != null )
        {
            try
            {
                result = readFully( process.getInputStream() );
            }
            catch( Exception e )
            {
                e.printStackTrace();
            }
            endProcess( process );
        }
        return result;
    }

    public static String executeCommandAndGetFirstLine( String cmd )
    {
        String result = "";
        Process process = exec(cmd);
        if ( process != null )
        {
            result = readFirstLine( process.getInputStream() );
            endProcess( process );
        }
        return result;
    }

    public static String readFully(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = is.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toString("UTF-8");
    }

    public static String readFirstLine( InputStream is )
    {
        String result = null;
        try
        {
            BufferedReader reader = new BufferedReader( new InputStreamReader( is ) );
            result = reader.readLine();
        }
        catch ( Exception e )
        {
            e.printStackTrace();
        }
        return result;
    }

    static String getAllRunningProcessNames()
    {
        Process process = null;
        String result = null;
        try
        {
            process = Runtime.getRuntime().exec("/system/bin/ls /proc");
            if ( process == null ) { return result; }
            process.waitFor();
            String processLine = "";
            String line;
            BufferedReader reader = new BufferedReader( new InputStreamReader( process.getInputStream() ) );
            while ( (line = reader.readLine() ) != null )
            {
                try
                {
                    int processId = Integer.parseInt(line); // if this does not throw exception then it is a valid int
                    Process p = Runtime.getRuntime().exec("/system/bin/cat /proc/"+line+"/status");
                    String nameLine = readFirstLine( p.getInputStream() );
                    if ( nameLine != null )
                    {
                        nameLine = nameLine.replace( "Name:\t", "" );
                        processLine += nameLine+"|";
                        Log.i(TAG,nameLine);
                    }
                }
                catch( Exception e ) { }
            }
            result = processLine;
        }
        catch( Exception e ) {}

        return result;
    }

    public static void endProcess(Process process)
    {
        process.destroy();
    }

}
