/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.InvocationTargetException;
import org.json.JSONException;
import org.json.JSONObject;

public class DisplayProperties {
    private static final String TAG = DisplayProperties.class.getName();
    private static final String X_DPI = "xDpi";
    private static final String y_DPI = "yDpi";
    private static final String WIDTH_PIXELS = "widthPixels";
    private static final String HEIGHT_PIXELS = "heightPixels";

    public static JSONObject getProperties(Context context) throws JSONException {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int widthPixels = -1;
        int heightPixels = -1;
        display.getMetrics(metrics);
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(metrics);
            widthPixels = metrics.widthPixels;
            heightPixels = metrics.heightPixels;
        } else if (Build.VERSION.SDK_INT >= 14) {
            try {
                widthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                heightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                Log.d((String)TAG, (String)ex.toString());
            }
            catch (InvocationTargetException ex) {
                Log.d((String)TAG, (String)ex.toString());
            }
            catch (IllegalAccessException ex) {
                Log.d((String)TAG, (String)ex.toString());
            }
        }
        if (widthPixels == -1 || heightPixels == -1) {
            widthPixels = metrics.widthPixels;
            heightPixels = metrics.heightPixels;
        }
        JSONObject props = new JSONObject();
        props.put(WIDTH_PIXELS, widthPixels);
        props.put(HEIGHT_PIXELS, heightPixels);
        props.put(X_DPI, (double)metrics.xdpi);
        props.put(y_DPI, (double)metrics.ydpi);
        return props;
    }
}

